/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.composer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.nayrus.noteblockmaster.composer.ComposerBlockEntity;
import net.nayrus.noteblockmaster.composer.Note;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.sound.AdvancedInstrument;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ComposerRenderer
implements BlockEntityRenderer<ComposerBlockEntity> {
    public void render(ComposerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        ItemStack item = blockEntity.getItem();
        if (item.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.rotateAround(Axis.ZP.rotationDegrees(-blockEntity.getRotation() - 45.0f), 0.5f, -0.5f, 0.0f);
        poseStack.translate(0.48, -0.7, 0.966);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        renderer.renderStatic(item, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 1);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderScreenOverlay(GuiGraphics guiGraphics, List<Note> notes, ComposeData data) {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        Map<Byte, Integer> instrumentCountOnBeat = ComposerRenderer.countInstruments(notes, data);
        int drawIndex = 0;
        for (byte b = 0; b < AdvancedInstrument.values().length; b = (byte)(b + 1)) {
            int count = instrumentCountOnBeat.getOrDefault(b, -1);
            if (count == -1) continue;
            int x = drawIndex % 3 * 30 + 3;
            int y = screenHeight - drawIndex / 3 * 30 - 19;
            guiGraphics.renderItem(AdvancedInstrument.renderStack[b], x, y);
            guiGraphics.drawString(mc.font, "" + count, x + 20, y + 5, 0xFFFFFF, false);
            ++drawIndex;
        }
    }

    private static Map<Byte, Integer> countInstruments(List<Note> notes, ComposeData data) {
        HashMap<Byte, Integer> instrumentCountOnBeat = new HashMap<Byte, Integer>();
        int i = 0;
        while (i < notes.size()) {
            Note note = notes.get(i);
            int finalIndex = i++;
            instrumentCountOnBeat.compute(note.instrument(), (instrumentKey, count) -> {
                int n;
                if (data.hasPlaced(finalIndex)) {
                    return count;
                }
                if (count != null) {
                    count = count + 1;
                    n = count;
                } else {
                    n = 1;
                }
                return n;
            });
        }
        return instrumentCountOnBeat;
    }
}

