/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.composer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.sound.AdvancedInstrument;
import net.nayrus.noteblockmaster.utils.Utils;

public record Note(byte instrument, byte key, byte volume, byte pitch) {
    public static final Codec<Note> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("data").forGetter(Note::packNote)).apply((Applicative)instance, Note::new));
    public static final StreamCodec<FriendlyByteBuf, Note> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Note::packNote, Note::new);

    public Note(int data) {
        this(Note.getInstrument(data), Note.getKey(data), Note.getVolume(data), Note.getPitch(data));
    }

    public static Note of(libs.felnull.fnnbs.Note nbsNote) {
        byte instrument = (byte)Math.clamp((long)nbsNote.getInstrument(), 0, AdvancedInstrument.values().length - 1);
        byte key = (byte)(Math.clamp((long)nbsNote.getKey(), 3 + AdvancedNoteBlock.MIN_NOTE_VAL, 3 + AdvancedNoteBlock.MAX_NOTE_VAL) - 3);
        byte keyShift = (byte)Math.clamp((long)(nbsNote.getPitch() / 100), AdvancedNoteBlock.MIN_NOTE_VAL - key, AdvancedNoteBlock.MAX_NOTE_VAL - key);
        key = (byte)(key + keyShift);
        byte volume = (byte)((float)Math.clamp((long)nbsNote.getVelocity(), 0, 100) * 0.2f);
        byte pitch = (byte)(nbsNote.getPitch() % 100);
        return new Note(instrument, key, volume, pitch);
    }

    @Override
    public String toString() {
        return "Instrument: " + String.valueOf((Object)AdvancedInstrument.values()[this.instrument]) + ", Key: " + Utils.NOTE_STRING[this.key] + ", Volume: " + this.volume * 5 + "%, Pitch: " + this.pitch;
    }

    public int packNote() {
        return this.instrument() & 0xFF | (this.key() & 0xFF) << 8 | (this.volume() & 0xFF) << 16 | (this.pitch() & 0xFF) << 24;
    }

    public static byte getInstrument(int data) {
        return (byte)data;
    }

    public static byte getKey(int data) {
        return (byte)(data >> 8);
    }

    public static byte getVolume(int data) {
        return (byte)(data >> 16);
    }

    public static byte getPitch(int data) {
        return (byte)(data >> 24);
    }
}

