/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.composer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.nayrus.noteblockmaster.NoteBlockMaster;
import net.nayrus.noteblockmaster.composer.ComposerNetwork;
import net.nayrus.noteblockmaster.composer.SongData;
import net.nayrus.noteblockmaster.composer.SongFileManager;
import net.nayrus.noteblockmaster.setup.Registry;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SongCache
extends SavedData {
    public static SongCache SERVER_CACHE;
    public static SongCache CLIENT_CACHE;
    private final ConcurrentHashMap<UUID, SongData> cache = new ConcurrentHashMap();
    private final boolean isLocal;
    @OnlyIn(value=Dist.CLIENT)
    private static final HashMap<UUID, Long> pendingSongRequest;
    private static final ConcurrentHashMap<UUID, CompletableFuture<Boolean>> pendingKeyChecks;

    public SongCache(boolean local) {
        this.isLocal = local;
    }

    public SongCache create(boolean local) {
        return new SongCache(local);
    }

    public SongCache load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        SongCache data = this.create(false);
        if (tag.contains("SongCache", 9)) {
            ListTag songList = tag.getList("SongCache", 10);
            for (int i = 0; i < songList.size(); ++i) {
                CompoundTag songTag = songList.getCompound(i);
                UUID key = songTag.getUUID("ID");
                SongFileManager.registeredSongs.add(key);
                SongData songData = SongData.load(songTag.getCompound("Data"));
                data.cache.put(key, songData);
            }
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        return this.saveCacheOnTag(tag);
    }

    public CompoundTag saveCacheOnTag(CompoundTag tag) {
        ListTag songList = new ListTag();
        for (Map.Entry<UUID, SongData> entry : this.cache.entrySet()) {
            CompoundTag songTag = new CompoundTag();
            songTag.putUUID("ID", entry.getKey());
            songTag.put("Data", (Tag)entry.getValue().save(new CompoundTag()));
            songList.add((Object)songTag);
        }
        tag.put("SongCache", (Tag)songList);
        return tag;
    }

    public void saveCachedSongs() throws IOException {
        for (SongData song : this.cache.values()) {
            SongFileManager.safeCachedSong(song);
        }
    }

    public boolean saveIfPresent(UUID id) {
        if (!this.cache.containsKey(id)) {
            return false;
        }
        try {
            SongFileManager.safeCachedSong(this.cache.get(id));
        }
        catch (IOException e) {
            NoteBlockMaster.LOGGER.error("Error saving song {} - {}", (Object)id, (Object)e.getLocalizedMessage());
        }
        return true;
    }

    public boolean loadSongFromFile(UUID id) {
        SongData songData = SongFileManager.loadCachedSong(id);
        if (songData == null) {
            SongFileManager.registeredSongs.remove(id);
            NoteBlockMaster.LOGGER.debug("Tried to load not-existing cached song file of {}", (Object)id);
            return false;
        }
        if (!SongFileManager.registeredSongs.contains(id)) {
            SongFileManager.registeredSongs.add(id);
        }
        this.cache.put(id, songData);
        return true;
    }

    public void flushCache() throws IOException {
        if (this.isLocal) {
            CLIENT_CACHE.saveCachedSongs();
        } else {
            SERVER_CACHE.saveCachedSongs();
        }
    }

    public void saveAndClearCache() {
        NoteBlockMaster.LOGGER.debug("Saving & clearing song cache");
        try {
            this.flushCache();
            this.cache.clear();
            this.setDirty();
        }
        catch (IOException e) {
            NoteBlockMaster.LOGGER.error("Error druring cache safe - {}", (Object)e.getLocalizedMessage());
        }
    }

    private void cache(UUID id, SongData data) {
        this.cache.put(id, data);
    }

    public CompletableFuture<SongData> getSongFromServer(UUID id) {
        if (!this.isLocal) {
            return CompletableFuture.completedFuture(this.getFromCache(id));
        }
        CompletableFuture<SongData> song = new CompletableFuture<SongData>();
        this.hasServerKey(id).thenAccept(hasKey -> {
            if (!hasKey.booleanValue()) {
                song.complete(null);
                return;
            }
            ComposerNetwork.pullRequests.put(id, song);
            PacketDistributor.sendToServer((CustomPacketPayload)new PullRequest(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        return song;
    }

    public static void cacheSong(UUID id, SongData data) {
        SongCache instance = FMLEnvironment.dist == Dist.CLIENT ? CLIENT_CACHE : SERVER_CACHE;
        SongCache.cacheSong(id, data, instance);
    }

    public static void cacheSong(UUID id, SongData data, SongCache instance) {
        if (!instance.cache.containsKey(id)) {
            instance.cache(id, data);
            if (!instance.isLocal && !SongFileManager.registeredSongs.contains(id)) {
                SongFileManager.registeredSongs.add(id);
            }
        } else {
            NoteBlockMaster.LOGGER.info("Song ID {} is already cached", (Object)id);
        }
        instance.setDirty();
    }

    @Nullable
    public static SongData getSong(UUID id, ItemStack IDHolder) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            SongCache cache = CLIENT_CACHE;
            SongData data = cache.getFromCache(id);
            if (data == null) {
                pendingSongRequest.computeIfPresent(id, (uuid, time) -> {
                    if (time + 1000L > Util.getMillis()) {
                        return time;
                    }
                    return null;
                });
                if (!pendingSongRequest.containsKey(id)) {
                    cache.hasServerKey(id).thenAccept(hasKey -> {
                        if (!hasKey.booleanValue()) {
                            IDHolder.remove(Registry.SONG_ID);
                            pendingSongRequest.remove(id);
                        } else {
                            cache.getSongFromServer(id).thenAccept(songData -> {
                                if (songData != null) {
                                    cache.cache(id, (SongData)songData);
                                }
                                pendingSongRequest.remove(id);
                            });
                        }
                    });
                    pendingSongRequest.put(id, Util.getMillis());
                }
            }
            return data;
        }
        SongCache cache = SERVER_CACHE;
        return cache.getFromCache(id);
    }

    public void dropSong(UUID id) {
        this.cache.remove(id);
        if (!this.isLocal) {
            try {
                SongFileManager.deleteCachedSong(id);
                SongFileManager.registeredSongs.removeIf(currentID -> currentID.compareTo(id) == 0);
            }
            catch (IOException e) {
                NoteBlockMaster.LOGGER.error("Could not delete cached song {} - {}", (Object)id, (Object)e.getLocalizedMessage());
            }
        }
        this.setDirty();
    }

    public List<String> getCachedSongInfo() {
        ArrayList<String> songInfos = new ArrayList<String>();
        for (Map.Entry<UUID, SongData> entry : this.cache.entrySet()) {
            songInfos.add(entry.getKey().toString() + " // " + entry.getValue().title() + " by " + entry.getValue().author());
        }
        return songInfos;
    }

    public List<String> getRegisteredSongIDs() {
        ArrayList<String> asString = new ArrayList<String>();
        SongFileManager.registeredSongs.forEach(uuid -> asString.add(uuid.toString()));
        return asString;
    }

    @Nullable
    private SongData getFromCache(UUID id) {
        return this.cache.getOrDefault(id, null);
    }

    public SongCache loadFromWorld(ServerLevel overworld) {
        return (SongCache)overworld.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> this.create(false), this::load), "songcache");
    }

    public static void handlePullRequest(PullRequest data, IPayloadContext context) {
        if (SERVER_CACHE != null) {
            ServerPlayer player = (ServerPlayer)context.player();
            SongData songData = SERVER_CACHE.getFromCache(data.songID());
            if (songData == null) {
                NoteBlockMaster.LOGGER.warn("{} send a pull request for a non-existing song", (Object)player.getName());
                return;
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)songData, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void handlePushRequest(PushRequest data, IPayloadContext context) {
        if (CLIENT_CACHE != null) {
            Player player = context.player();
            SongData songData = CLIENT_CACHE.getFromCache(data.songID());
            if (songData == null) {
                NoteBlockMaster.LOGGER.warn("The Server send a push request for a non-existing song");
                return;
            }
            player.displayClientMessage((Component)Component.literal((String)("Pushing song " + songData.title() + " by " + songData.author() + " to server")), false);
            PacketDistributor.sendToServer((CustomPacketPayload)songData, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void handleDropRequest(DropRequest data, IPayloadContext context) {
        if (CLIENT_CACHE != null) {
            Player player = context.player();
            SongData songData = CLIENT_CACHE.getFromCache(data.songID());
            if (songData == null) {
                NoteBlockMaster.LOGGER.warn("Could not delete song with unknown UUID {}", (Object)data.songID());
                return;
            }
            player.displayClientMessage((Component)Component.literal((String)("Deleted song " + songData.title() + " by " + songData.author())), false);
            CLIENT_CACHE.dropSong(data.songID());
        }
    }

    public CompletableFuture<Boolean> hasServerKey(UUID id) {
        if (!this.isLocal) {
            if (this.cache.containsKey(id)) {
                return CompletableFuture.completedFuture(true);
            }
            if (!SongFileManager.registeredSongs.contains(id)) {
                return CompletableFuture.completedFuture(false);
            }
            return CompletableFuture.completedFuture(this.loadSongFromFile(id));
        }
        if (!pendingKeyChecks.containsKey(id)) {
            CompletableFuture<Boolean> hasServerKey = new CompletableFuture<Boolean>();
            pendingKeyChecks.put(id, hasServerKey);
            PacketDistributor.sendToServer((CustomPacketPayload)new KeyCheck(id, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return hasServerKey;
        }
        return pendingKeyChecks.get(id);
    }

    public static void handleKeyCheckOnServer(KeyCheck data, IPayloadContext context) {
        if (SERVER_CACHE != null) {
            try {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)context.player()), (CustomPacketPayload)new KeyCheck(data.key(), SERVER_CACHE.hasServerKey(data.key()).get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            catch (Exception e) {
                NoteBlockMaster.LOGGER.error(Arrays.toString(e.getStackTrace()));
            }
        }
    }

    public static void handleKeyCheckOnClient(KeyCheck data, IPayloadContext context) {
        if (!pendingKeyChecks.containsKey(data.key())) {
            NoteBlockMaster.LOGGER.warn("Server tried to confirm existence of unknown song");
            return;
        }
        pendingKeyChecks.get(data.key()).complete(data.hasServerKey());
        pendingKeyChecks.remove(data.key());
    }

    static {
        pendingSongRequest = new HashMap();
        pendingKeyChecks = new ConcurrentHashMap();
    }

    public record PullRequest(UUID songID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PullRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"songcache.pullrequest"));
        public static final StreamCodec<FriendlyByteBuf, PullRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PullRequest::songID, PullRequest::new);

        public CustomPacketPayload.Type<PullRequest> type() {
            return TYPE;
        }
    }

    public record PushRequest(UUID songID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PushRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"songcache.pushrequest"));
        public static final StreamCodec<FriendlyByteBuf, PushRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PushRequest::songID, PushRequest::new);

        public CustomPacketPayload.Type<PushRequest> type() {
            return TYPE;
        }
    }

    public record DropRequest(UUID songID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<DropRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"songcache.droprequest"));
        public static final StreamCodec<FriendlyByteBuf, DropRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, DropRequest::songID, DropRequest::new);

        public CustomPacketPayload.Type<DropRequest> type() {
            return TYPE;
        }
    }

    public record KeyCheck(UUID key, boolean hasServerKey) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<KeyCheck> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"songcache.keycheck"));
        public static final StreamCodec<FriendlyByteBuf, KeyCheck> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, KeyCheck::key, (StreamCodec)ByteBufCodecs.BOOL, KeyCheck::hasServerKey, KeyCheck::new);

        public CustomPacketPayload.Type<KeyCheck> type() {
            return TYPE;
        }
    }
}

