/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.composer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import libs.felnull.fnnbs.Layer;
import libs.felnull.fnnbs.NBS;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.nayrus.noteblockmaster.composer.Note;

public record SongData(String title, String author, Map<String, List<Note>> notes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SongData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"songdata"));
    public static final Codec<SongData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("title").forGetter(SongData::title), (App)Codec.STRING.fieldOf("author").forGetter(SongData::author), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.list(Note.CODEC)).fieldOf("notes").forGetter(SongData::notes)).apply((Applicative)instance, SongData::new));
    public static final StreamCodec<FriendlyByteBuf, SongData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SongData::title, (StreamCodec)ByteBufCodecs.STRING_UTF8, SongData::author, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, Note.STREAM_CODEC, (int)32)), SongData::notes, SongData::new);

    public CustomPacketPayload.Type<SongData> type() {
        return TYPE;
    }

    public static SongData of(NBS nbs) {
        List<Layer> layers = nbs.getLayers();
        HashMap<String, List<Note>> notes = new HashMap<String, List<Note>>();
        for (int beat = 0; beat <= nbs.getSongLength(); ++beat) {
            ArrayList notesAtLayer = new ArrayList();
            int finalBeat = beat;
            layers.forEach(layer -> {
                libs.felnull.fnnbs.Note current = layer.getNote(finalBeat);
                if (current != null) {
                    notesAtLayer.add(Note.of(current));
                }
            });
            if (notesAtLayer.size() > 32) {
                throw new IllegalStateException("The song " + nbs.getName() + " by " + nbs.getAuthor() + " has more than 32 notes at tick " + finalBeat);
            }
            if (notesAtLayer.isEmpty()) continue;
            notes.put("" + finalBeat, notesAtLayer);
        }
        return new SongData(nbs.getName(), nbs.getAuthor(), notes);
    }

    public static SongData load(CompoundTag tag) {
        HashMap<String, List<Note>> notesMap = new HashMap<String, List<Note>>();
        if (tag.contains("Notes", 10)) {
            CompoundTag notesTag = tag.getCompound("Notes");
            for (String beat : notesTag.getAllKeys()) {
                int[] packedNotes = notesTag.getIntArray(beat);
                ArrayList<Note> notesAtBeat = new ArrayList<Note>();
                for (int packedNote : packedNotes) {
                    notesAtBeat.add(new Note(packedNote));
                }
                notesMap.put(beat, notesAtBeat);
            }
        }
        return new SongData(tag.getString("Title"), tag.getString("Author"), notesMap);
    }

    public CompoundTag save(CompoundTag tag) {
        CompoundTag notesTag = new CompoundTag();
        for (Map.Entry<String, List<Note>> entry : this.notes.entrySet()) {
            ArrayList packedNoteList = new ArrayList();
            entry.getValue().forEach(note -> packedNoteList.add(note.packNote()));
            if (packedNoteList.isEmpty()) continue;
            notesTag.put(entry.getKey(), (Tag)new IntArrayTag(packedNoteList));
        }
        tag.putString("Title", this.title());
        tag.putString("Author", this.author());
        tag.put("Notes", (Tag)notesTag);
        return tag;
    }

    public UUID getID() {
        return UUID.nameUUIDFromBytes(this.toString().getBytes());
    }

    public List<Note> getNotesAt(int index) {
        return this.notes().getOrDefault("" + index, List.of());
    }
}

