/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.composer;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import libs.felnull.fnnbs.NBS;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.nayrus.noteblockmaster.NoteBlockMaster;
import net.nayrus.noteblockmaster.composer.SongCache;
import net.nayrus.noteblockmaster.composer.SongData;
import org.jetbrains.annotations.Nullable;

public class SongFileManager {
    public static final HashSet<UUID> registeredSongs = new HashSet();
    public static Path SONG_DIR;
    public static Path CACHE_DIR;

    @Nullable
    public static NBS loadNBSFile(String name) {
        Path filePath = SONG_DIR.resolve(name + ".nbs");
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                return NBS.load(Files.newInputStream(filePath, new OpenOption[0]));
            }
            catch (IOException e) {
                NoteBlockMaster.LOGGER.error(e.getLocalizedMessage());
            }
        } else {
            NoteBlockMaster.LOGGER.warn("File not found: {}", (Object)filePath.toAbsolutePath());
        }
        return null;
    }

    public static void validateAndLoadCache() {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(CACHE_DIR);){
            HashSet<UUID> notValidated = new HashSet<UUID>(List.copyOf(registeredSongs));
            for (Path file : stream) {
                String name = file.getFileName().toString();
                try {
                    UUID id2 = UUID.fromString(name.substring(0, 36));
                    notValidated.remove(id2);
                    registeredSongs.add(id2);
                }
                catch (IllegalArgumentException e) {
                    NoteBlockMaster.LOGGER.warn("File {} is in the cache directory but is not a valid UUID", (Object)name);
                }
            }
            notValidated.removeIf(id -> SongCache.SERVER_CACHE.saveIfPresent((UUID)id) || !registeredSongs.remove(id));
        }
        catch (IOException e) {
            NoteBlockMaster.LOGGER.error("Could not validate the caching directory {}", (Object)e.getLocalizedMessage());
        }
    }

    public static void safeCachedSong(SongData song) throws IOException {
        Path filePath = CACHE_DIR.resolve(String.valueOf(song.getID()) + ".snbt");
        if (!Files.exists(filePath, new LinkOption[0])) {
            NbtIo.write((CompoundTag)song.save(new CompoundTag()), (Path)filePath);
        }
    }

    @Nullable
    public static SongData loadCachedSong(UUID id) {
        Path filePath = CACHE_DIR.resolve(String.valueOf(id) + ".snbt");
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                CompoundTag compoundTag = NbtIo.read((Path)filePath);
                if (!(compoundTag instanceof CompoundTag)) {
                    return null;
                }
                CompoundTag tag = compoundTag;
                return SongData.load(tag);
            }
            catch (IOException e) {
                NoteBlockMaster.LOGGER.warn("Could not open cached song file of {}", (Object)id);
                return null;
            }
        }
        return null;
    }

    public static void deleteCachedSong(UUID id) throws IOException {
        Path filePath = CACHE_DIR.resolve(String.valueOf(id) + ".snbt");
        if (Files.exists(filePath, new LinkOption[0])) {
            Files.delete(filePath);
        }
    }
}

