/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.sound.SoundRegistry;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredBlock;

public class NBMLangProvider
extends LanguageProvider {
    public NBMLangProvider(PackOutput output) {
        super(output, "noteblockmaster", "en_us");
    }

    protected void addTranslations() {
        this.addBlockWithItem(Registry.ADVANCED_NOTEBLOCK, "Advanced Note Block");
        this.addBlockWithItem(Registry.COMPOSER, "Composer");
        this.add((Block)Registry.TUNINGCORE.get(), "Tuning Core");
        this.add((Item)Registry.TEMPOTUNER.get(), "Tempo Tuner");
        this.add((Item)Registry.NOTETUNER.get(), "Note Tuner");
        this.add((Item)Registry.COMPOSITION.get(), "Composers Note");
        this.add((Item)Registry.CORE.get(), "Core Base");
        this.add((Item)Registry.SUSTAIN.get(), "Sustaining Core");
        this.add((Item)Registry.VOLUME.get(), "Mixing Core");
        this.add("key.categories.noteblockmaster.nbm", "Note Block Master");
        this.add("key.noteblockmaster.openoffhandgui", "Open Offhand GUI");
        this.addSounds();
        this.add("text.config.updated", "Updated local configs. Restart your client to apply");
        this.add("text.lowres.enable", "Activated low resolution render to save fps");
        this.add("text.lowres.disable", "Low resolution render deactivated");
        this.add("text.config.desync_warning", "[WARNING] Advanced Note Block info render may be partially disabled. Click here to synchronize your local config with the server.");
        this.add("text.config.save_sync_hovertext", "Synchronize & Safe conig");
    }

    public void addBlockWithItem(DeferredBlock<Block> block, String name) {
        this.add((Block)block.get(), name);
        this.add((Item)Registry.BLOCK_ITEMS.get(block).get(), name);
    }

    public void addSounds() {
        SoundRegistry.SOUND_EVENTS.getEntries().forEach(sound -> this.add(((SoundEvent)sound.get()).location().toLanguageKey("sounds"), ((SoundEvent)sound.get()).location().getPath() + " sound"));
    }
}

