/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.datagen.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.nayrus.noteblockmaster.NoteBlockMaster;
import net.nayrus.noteblockmaster.item.TunerItem;

public class TunerRecipe
extends ShapedRecipe {
    final ItemStack result;

    public TunerRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
        this.result = result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainingItems = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.getItem() instanceof TunerItem) {
                remainingItems.set(i, (Object)ItemStack.EMPTY);
                continue;
            }
            if (stack.isEmpty() || stack.getCraftingRemainder().isEmpty()) continue;
            remainingItems.set(i, (Object)stack.getCraftingRemainder());
        }
        return remainingItems;
    }

    public RecipeSerializer<? extends ShapedRecipe> getSerializer() {
        return (RecipeSerializer)NoteBlockMaster.TUNER_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<TunerRecipe> {
        public static final MapCodec<TunerRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340778_ -> p_340778_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(ShapedRecipe::showNotification)).apply((Applicative)p_340778_, TunerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TunerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<TunerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TunerRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static TunerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean flag = buffer.readBoolean();
            return new TunerRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, TunerRecipe recipe) {
            buffer.writeUtf(recipe.group());
            buffer.writeEnum((Enum)recipe.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.showNotification());
        }
    }
}

