/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.event;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.nayrus.noteblockmaster.composer.ComposerRenderer;
import net.nayrus.noteblockmaster.composer.SongCache;
import net.nayrus.noteblockmaster.composer.SongData;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.network.data.SongID;
import net.nayrus.noteblockmaster.render.ANBInfoRender;
import net.nayrus.noteblockmaster.render.CoreRender;
import net.nayrus.noteblockmaster.render.utils.RenderUtils;
import net.nayrus.noteblockmaster.screen.CompositionScreen;
import net.nayrus.noteblockmaster.setup.NBMTags;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.sound.CoreSound;
import net.nayrus.noteblockmaster.sound.SubTickScheduler;
import net.nayrus.noteblockmaster.utils.FinalTuple;
import net.nayrus.noteblockmaster.utils.KeyBindings;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundSourceEvent;

public class ClientEvents {
    public static long ticks = 0L;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        while (((KeyMapping)KeyBindings.OPEN_OFFHAND_GUI.get()).consumeClick()) {
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (!(localPlayer instanceof Player)) {
                return;
            }
            LocalPlayer player = localPlayer;
            ItemStack off = player.getOffhandItem();
            if (off.is(NBMTags.Items.TUNERS)) {
                TunerItem.openTunerGUI(off, player.getMainHandItem(), true);
            }
            if (!off.is(Registry.COMPOSITION)) continue;
            Minecraft.getInstance().setScreen((Screen)new CompositionScreen(off));
        }
        if (ticks % 200L == 0L) {
            CoreRender.clearMaps();
        }
        ++ticks;
    }

    @SubscribeEvent
    public static void renderBlockOverlays(RenderLevelStageEvent e) {
        if (!RenderUtils.eventOnRelevantStage(e)) {
            return;
        }
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (!(localPlayer instanceof Player)) {
            return;
        }
        LocalPlayer player = localPlayer;
        RenderUtils.CURRENT_CAM_POS = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Level level = player.level();
        if (e.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems((Player)player);
            if (((ItemStack)items.getA()).is(NBMTags.Items.TUNERS)) {
                ANBInfoRender.renderNoteBlockInfo(e, level, ((ItemStack)items.getA()).is(Registry.NOTETUNER) ? Utils.PROPERTY.NOTE : Utils.PROPERTY.TEMPO);
            } else if (((ItemStack)items.getB()).is(NBMTags.Items.TUNERS)) {
                ANBInfoRender.renderNoteBlockInfo(e, level, ((ItemStack)items.getB()).is(Registry.NOTETUNER) ? Utils.PROPERTY.NOTE : Utils.PROPERTY.TEMPO);
            }
        }
        CoreRender.renderCoresInRange(e, level);
    }

    @SubscribeEvent
    public static void renderGUIOverlays(RenderGuiEvent.Post event) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (!(localPlayer instanceof Player)) {
            return;
        }
        LocalPlayer player = localPlayer;
        FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems((Player)player);
        if (!items.contains((Item)Registry.COMPOSITION.get())) {
            return;
        }
        ItemStack composer_note = items.getFirst((Item)Registry.COMPOSITION.get());
        ComposeData cData = ComposeData.getComposeData(composer_note);
        player.displayClientMessage((Component)Component.literal((String)("Next repeater delay: " + cData.postDelay())).withColor(Color.RED.darker().getRGB()), true);
        Object object = composer_note.get(Registry.SONG_ID);
        if (object instanceof SongID) {
            UUID songID;
            SongID songID2 = (SongID)object;
            try {
                UUID uUID;
                songID = uUID = songID2.songID();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            SongData data = SongCache.getSong(songID, composer_note);
            if (data != null) {
                ComposerRenderer.renderScreenOverlay(event.getGuiGraphics(), data.getNotesAt(cData.beat()), cData);
            }
        }
    }

    @SubscribeEvent
    public static void playSoundSourceEvent(PlaySoundSourceEvent e) {
        SoundInstance soundInstance = e.getSound();
        if (!(soundInstance instanceof CoreSound)) {
            return;
        }
        CoreSound sound = (CoreSound)soundInstance;
        SubTickScheduler.SUSTAINED_SOUNDS.put(sound.getImmutablePos(), sound);
        sound.addNoteParticle();
        sound.setChannel(e.getChannel());
    }
}

