/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.event;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.NoteBlockMaster;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.command.BPMInfoCommand;
import net.nayrus.noteblockmaster.command.MainCommand;
import net.nayrus.noteblockmaster.composer.SongCache;
import net.nayrus.noteblockmaster.composer.SongFileManager;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.sound.SoundRegistry;
import net.nayrus.noteblockmaster.utils.FinalTuple;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.server.command.ConfigCommand;

public class CommonEvents {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        new BPMInfoCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        MainCommand.mainCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        NoteBlockMaster.LOGGER.info("Loading saved songs");
        SongCache.SERVER_CACHE = new SongCache(false).loadFromWorld(server.overworld());
        SongFileManager.validateAndLoadCache();
    }

    @SubscribeEvent
    public static void useItemOnBlockEvent(UseItemOnBlockEvent event) {
        UseOnContext context = event.getUseOnContext();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player instanceof Player) {
            Inventory inv;
            Player player2 = player;
            BlockPos pos = context.getClickedPos();
            BlockState state = level.getBlockState(pos);
            FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems(player2);
            if (items.contains(TunerItem.class) && state.getBlock() instanceof NoteBlock && (inv = player2.getInventory()).countItem(Items.GOLD_NUGGET) >= 3) {
                if (!level.isClientSide) {
                    level.setBlock(pos, (BlockState)((Block)Registry.ADVANCED_NOTEBLOCK.get()).defaultBlockState().setValue((Property)AdvancedNoteBlock.NOTE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)NoteBlock.NOTE) + AdvancedNoteBlock.DEFAULT_NOTE)), 3);
                    level.playSound(null, pos, SoundRegistry.SMITHING.get(), SoundSource.BLOCKS, 0.5f, NoteBlock.getPitchFromNote((int)14) + RandomSource.create().nextFloat() / 10.0f);
                    if (!player2.isCreative()) {
                        Utils.removeItemsFromInventory(inv, Items.GOLD_NUGGET, 3);
                    }
                } else {
                    level.addDestroyBlockEffect(pos, Blocks.GOLD_BLOCK.defaultBlockState());
                }
                if (((ItemStack)items.getA()).getItem() instanceof TunerItem) {
                    event.cancelWithResult((InteractionResult)InteractionResult.SUCCESS);
                } else {
                    player2.swing(InteractionHand.OFF_HAND);
                    event.cancelWithResult((InteractionResult)InteractionResult.CONSUME);
                }
            }
            if (state.getBlock() instanceof RepeaterBlock && items.contains((Item)Registry.COMPOSITION.get())) {
                ItemStack composer = items.getFirst((Item)Registry.COMPOSITION.get());
                ComposeData cData = ComposeData.getComposeData(composer);
                int target = cData.postDelay();
                int set = Math.min(target, 4);
                if (target > 0) {
                    target -= set;
                    if (!level.isClientSide()) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)RepeaterBlock.DELAY, (Comparable)Integer.valueOf(set)), 3);
                        composer.set(Registry.COMPOSE_DATA, (Object)new ComposeData(cData.beat(), cData.subtick(), target, cData.bpm(), cData.placed()));
                    }
                    if (((ItemStack)items.getA()).is(Registry.COMPOSITION)) {
                        event.cancelWithResult((InteractionResult)InteractionResult.SUCCESS);
                    } else {
                        event.cancelWithResult((InteractionResult)InteractionResult.CONSUME);
                        player2.swing(InteractionHand.OFF_HAND);
                    }
                } else {
                    event.cancelWithResult((InteractionResult)InteractionResult.FAIL);
                    if (level.isClientSide()) {
                        Utils.playFailUse(level, player2, pos);
                    }
                }
            }
        }
    }
}

