/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.block.TuningCore;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.sound.AdvancedInstrument;
import net.nayrus.noteblockmaster.utils.Utils;

public class SpinningCore
extends Item {
    public SpinningCore(ResourceLocation key) {
        super(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key)));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if (state.is(Registry.ADVANCED_NOTEBLOCK)) {
            return this.addCoreToAdvancedNoteBlock(level, player, pos, context.getHand(), (AdvancedInstrument)((Object)state.getValue(AdvancedNoteBlock.INSTRUMENT)));
        }
        return InteractionResult.PASS;
    }

    public InteractionResult addCoreToAdvancedNoteBlock(Level level, Player player, BlockPos pos, InteractionHand hand, AdvancedInstrument instrument) {
        BlockState state = level.getBlockState(pos.above());
        ItemStack stack = player.getItemInHand(hand);
        if (state.is(Registry.TUNINGCORE)) {
            return this.addCoreToTuningCore(level, player, pos.above(), state, stack, hand, instrument);
        }
        if (!state.isAir()) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide()) {
            state = ((Block)Registry.TUNINGCORE.get()).defaultBlockState();
            level.setBlockAndUpdate(pos.above(), stack.is(Registry.SUSTAIN) ? (BlockState)state.setValue((Property)TuningCore.SUSTAIN, (Comparable)Integer.valueOf(instrument.getSustains())) : (BlockState)state.setValue((Property)TuningCore.VOLUME, (Comparable)Integer.valueOf(20)));
            stack.shrink(1);
            SpinningCore.addIronNugget(player);
            level.playSound(null, pos, TuningCore.CORE_SOUNDS.getPlaceSound(), SoundSource.BLOCKS);
            if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (hand.equals((Object)InteractionHand.OFF_HAND)) {
            player.swing(hand);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult addCoreToTuningCore(Level level, Player player, BlockPos pos, BlockState state, ItemStack stack, InteractionHand hand, AdvancedInstrument instrument) {
        if (stack.is(Registry.SUSTAIN)) {
            if (TuningCore.isSustaining(state)) {
                return InteractionResult.SUCCESS;
            }
            if (level.isClientSide()) {
                return Utils.swingHelper(player, hand, true);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TuningCore.SUSTAIN, (Comparable)Integer.valueOf(instrument.getSustains())));
        } else {
            if (TuningCore.isMixing(state)) {
                return InteractionResult.SUCCESS;
            }
            if (level.isClientSide()) {
                return Utils.swingHelper(player, hand, true);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TuningCore.VOLUME, (Comparable)Integer.valueOf(20)));
        }
        stack.shrink(1);
        SpinningCore.addIronNugget(player);
        level.playSound(null, pos, TuningCore.CORE_SOUNDS.getPlaceSound(), SoundSource.BLOCKS);
        return Utils.swingHelper(player, hand, false);
    }

    private static void addIronNugget(Player player) {
        if (player.isCreative()) {
            return;
        }
        Inventory inv = player.getInventory();
        ItemStack nugget = new ItemStack((ItemLike)Items.IRON_NUGGET);
        if (inv.getFreeSlot() == -1 && inv.getSlotWithRemainingSpace(nugget) == -1) {
            player.drop(nugget, false, false);
        } else {
            player.getInventory().add(new ItemStack((ItemLike)Items.IRON_NUGGET));
        }
    }
}

