/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.item;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.composer.Note;
import net.nayrus.noteblockmaster.composer.SongCache;
import net.nayrus.noteblockmaster.composer.SongData;
import net.nayrus.noteblockmaster.item.ComposersNote;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.network.data.SongID;
import net.nayrus.noteblockmaster.network.data.TunerData;
import net.nayrus.noteblockmaster.screen.NoteTunerScreen;
import net.nayrus.noteblockmaster.screen.TempoTunerScreen;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TunerItem
extends Item {
    public TunerItem(ResourceLocation key) {
        super(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key)));
    }

    public ItemStack getCraftingRemainder(ItemStack itemStack) {
        return itemStack.copy();
    }

    public static TunerData getTunerData(ItemStack stack) {
        TunerData data = (TunerData)stack.get(Registry.TUNER_DATA);
        if (data == null) {
            data = TunerData.of(1, false, false);
            stack.set(Registry.TUNER_DATA, (Object)data);
        }
        return data;
    }

    public InteractionResult useOn(UseOnContext context, boolean doOffHandSwing) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        ItemStack tuner = context.getItemInHand();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack composer = player.getOffhandItem();
        if (!tuner.is((Item)this)) {
            tuner = composer;
            composer = context.getItemInHand();
        }
        TunerData data = TunerItem.getTunerData(tuner);
        Block block = state.getBlock();
        if (!(block instanceof AdvancedNoteBlock)) {
            if (!data.isSetmode() && !composer.is(Registry.COMPOSITION)) {
                return InteractionResult.PASS;
            }
            Inventory inv = player.getInventory();
            if (inv.contains(item -> item.is(Registry.ADVANCED_NOTEBLOCK.asItem())) && !doOffHandSwing) {
                TunerItem.placeAdvancedNoteBlock(level, tuner, pos, data, composer, player, inv);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        AdvancedNoteBlock block2 = (AdvancedNoteBlock)block;
        if (!player.isShiftKeyDown()) {
            if (tuner.is(Registry.TEMPOTUNER)) {
                return TunerItem.changeSubtickOn(level, block2, composer, data, state, player, pos, doOffHandSwing);
            }
            if (tuner.is(Registry.NOTETUNER)) {
                return TunerItem.changeNoteOn(level, state, block2, composer, data, player, pos);
            }
        }
        return InteractionResult.PASS;
    }

    private static void placeAdvancedNoteBlock(Level level, ItemStack tuner, BlockPos pos, TunerData data, ItemStack composer, Player player, Inventory inv) {
        if (!level.isClientSide()) {
            AdvancedNoteBlock block = (AdvancedNoteBlock)((Object)Registry.ADVANCED_NOTEBLOCK.get());
            if (tuner.is(Registry.NOTETUNER)) {
                BlockState state = (BlockState)block.defaultBlockState().setValue((Property)AdvancedNoteBlock.NOTE, (Comparable)Integer.valueOf(data.value() + AdvancedNoteBlock.MIN_NOTE_VAL));
                if (composer.is(Registry.TEMPOTUNER)) {
                    state = (BlockState)state.setValue((Property)AdvancedNoteBlock.SUBTICK, (Comparable)Integer.valueOf(TunerItem.getTunerData(composer).value()));
                }
                level.setBlockAndUpdate(pos.above(), block.setInstrument((LevelReader)level, pos.above(), state));
            } else if (composer.is(Registry.COMPOSITION)) {
                ComposeData cData = ComposeData.getComposeData(composer);
                if (!player.isShiftKeyDown()) {
                    Tuple<Integer, Integer> next = ComposersNote.subtickAndPauseOnBeat(cData.beat() + 1, cData.bpm());
                    ComposeData new_ = new ComposeData(cData.beat() + 1, (Integer)next.getA(), (Integer)next.getB(), cData.bpm(), 0);
                    composer.set(Registry.COMPOSE_DATA, (Object)new_);
                    cData = new_;
                }
                level.setBlockAndUpdate(pos.above(), (BlockState)block.setInstrument((LevelReader)level, pos.above(), block.defaultBlockState()).setValue((Property)AdvancedNoteBlock.SUBTICK, (Comparable)Integer.valueOf(cData.subtick())));
            } else {
                BlockState state = (BlockState)block.defaultBlockState().setValue((Property)AdvancedNoteBlock.SUBTICK, (Comparable)Integer.valueOf(data.value()));
                if (composer.is(Registry.NOTETUNER)) {
                    state = (BlockState)state.setValue((Property)AdvancedNoteBlock.NOTE, (Comparable)Integer.valueOf(TunerItem.getTunerData(composer).value() + AdvancedNoteBlock.MIN_NOTE_VAL));
                }
                level.setBlockAndUpdate(pos.above(), block.setInstrument((LevelReader)level, pos.above(), state));
            }
            level.playSound(null, pos, SoundType.WOOD.getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
            if (!player.isCreative()) {
                Utils.removeItemsFromInventory(inv, Registry.ADVANCED_NOTEBLOCK.asItem(), 1);
            }
        }
    }

    private static InteractionResult changeNoteOn(Level level, BlockState state, AdvancedNoteBlock block, ItemStack composer, TunerData data, Player player, BlockPos pos) {
        if (!level.isClientSide()) {
            int new_val;
            if (!composer.is(Registry.COMPOSITION) || !composer.has(Registry.SONG_ID)) {
                new_val = TunerItem.getNewNoteValue(block, state, data);
            } else {
                ComposeData composeData = ComposeData.getComposeData(composer);
                SongData songData = SongCache.getSong(Objects.requireNonNull((SongID)composer.get(Registry.SONG_ID)).songID(), composer);
                if (songData == null) {
                    new_val = TunerItem.getNewNoteValue(block, state, data);
                } else {
                    int note_index = composeData.nextNoteIndex();
                    Note note = songData.getNotesAt(composeData.beat()).get(note_index);
                    new_val = note.key();
                    composer.set(Registry.COMPOSE_DATA, (Object)new ComposeData(composeData.beat(), composeData.subtick(), composeData.postDelay(), composeData.bpm(), composeData.placed() | 1 << note_index));
                }
            }
            return block.onNoteChange(level, player, state, pos, new_val);
        }
        return InteractionResult.SUCCESS;
    }

    private static int getNewNoteValue(AdvancedNoteBlock block, BlockState state, TunerData data) {
        return data.isSetmode() ? data.value() + AdvancedNoteBlock.MIN_NOTE_VAL : block.changeNoteValueBy(state, data.value());
    }

    private static InteractionResult changeSubtickOn(Level level, AdvancedNoteBlock block, ItemStack composer, TunerData data, BlockState state, Player player, BlockPos pos, boolean doOffHandSwing) {
        if (!level.isClientSide()) {
            int new_val;
            if (!composer.is(Registry.COMPOSITION)) {
                new_val = (data.isSetmode() ? data.value() : (Integer)state.getValue((Property)AdvancedNoteBlock.SUBTICK) + data.value()) % AdvancedNoteBlock.SUBTICKS;
            } else {
                ComposeData cData = ComposeData.getComposeData(composer);
                new_val = cData.subtick();
                Tuple<Integer, Integer> next = ComposersNote.subtickAndPauseOnBeat(cData.beat() + 1, cData.bpm());
                composer.set(Registry.COMPOSE_DATA, (Object)new ComposeData(cData.beat() + 1, (Integer)next.getA(), (Integer)next.getB(), cData.bpm(), 0));
            }
            if (!doOffHandSwing) {
                return block.onSubtickChange(level, player, state, pos, new_val, true);
            }
            block.onSubtickChange(level, player, state, pos, new_val, true);
            return InteractionResult.CONSUME;
        }
        if (doOffHandSwing) {
            player.swing(InteractionHand.OFF_HAND);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.useOn(context, false);
    }

    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (level.isClientSide()) {
            TunerItem.openTunerGUI(itemstack, player.getItemInHand(InteractionHand.values()[(usedHand.ordinal() + 1) % 2]), usedHand == InteractionHand.OFF_HAND);
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openTunerGUI(ItemStack tuner, ItemStack second, boolean tunerInOffhand) {
        if (tuner.is(Registry.TEMPOTUNER)) {
            Minecraft.getInstance().setScreen((Screen)new TempoTunerScreen(tuner, second, tunerInOffhand));
        }
        if (tuner.is(Registry.NOTETUNER)) {
            Minecraft.getInstance().setScreen((Screen)new NoteTunerScreen(tuner, tunerInOffhand));
        }
    }
}

