/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.network;

import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import libs.felnull.fnnbs.NBS;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.NoteBlockMaster;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.block.TuningCore;
import net.nayrus.noteblockmaster.composer.ComposerBlockEntity;
import net.nayrus.noteblockmaster.composer.ComposerContainer;
import net.nayrus.noteblockmaster.composer.ComposerNetwork;
import net.nayrus.noteblockmaster.composer.SongCache;
import net.nayrus.noteblockmaster.composer.SongData;
import net.nayrus.noteblockmaster.composer.SongFileManager;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.network.data.SongID;
import net.nayrus.noteblockmaster.network.data.TunerData;
import net.nayrus.noteblockmaster.network.payload.ActionPing;
import net.nayrus.noteblockmaster.network.payload.ConfigCheck;
import net.nayrus.noteblockmaster.network.payload.CoreUpdate;
import net.nayrus.noteblockmaster.network.payload.LoadSong;
import net.nayrus.noteblockmaster.network.payload.ScheduleCoreSound;
import net.nayrus.noteblockmaster.network.payload.TickSchedule;
import net.nayrus.noteblockmaster.render.ANBInfoRender;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.setup.config.ClientConfig;
import net.nayrus.noteblockmaster.setup.config.StartupConfig;
import net.nayrus.noteblockmaster.sound.AdvancedInstrument;
import net.nayrus.noteblockmaster.sound.SubTickScheduler;
import net.nayrus.noteblockmaster.utils.FinalTuple;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketHandler {
    @SubscribeEvent
    public static void registerNetwork(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar reg = event.registrar("noteblockmaster");
        reg.playToClient(ConfigCheck.TYPE, ConfigCheck.STREAM_CODEC, PacketHandler::handleStartUpSync);
        reg.playToClient(ActionPing.TYPE, ActionPing.STREAM_CODEC, PacketHandler::handleActionPing);
        reg.playToClient(ScheduleCoreSound.TYPE, ScheduleCoreSound.STREAM_CODEC, PacketHandler::handleScheduleCoreSound);
        reg.playToClient(LoadSong.TYPE, LoadSong.STREAM_CODEC, PacketHandler::handleLoadSong);
        reg.playToServer(TunerData.TYPE, TunerData.TUNER_STREAM_CODEC, PacketHandler::handleTunerData);
        reg.playToServer(ComposeData.TYPE, ComposeData.STREAM_CODEC, PacketHandler::handleComposeData);
        reg.playToServer(TickSchedule.TYPE, TickSchedule.STREAM_CODEC, PacketHandler::handleTickSchedule);
        reg.playToServer(CoreUpdate.TYPE, CoreUpdate.STREAM_CODEC, PacketHandler::handleCoreUpdate);
        reg.playBidirectional(SongID.TYPE, SongID.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(PacketHandler::handleSongIDInHand, PacketHandler::handleSongIDOnComposer));
        ComposerNetwork.register(reg);
    }

    private static void handleStartUpSync(ConfigCheck packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (AdvancedNoteBlock.MIN_NOTE_VAL != packet.minNote() || AdvancedNoteBlock.MAX_NOTE_VAL != packet.maxNote()) {
                ANBInfoRender.NOTE_OFF_SYNC = true;
                AdvancedNoteBlock.MIN_NOTE_VAL = packet.minNote();
                AdvancedNoteBlock.MAX_NOTE_VAL = packet.maxNote();
                AdvancedNoteBlock.TOTAL_NOTES = AdvancedNoteBlock.MAX_NOTE_VAL - AdvancedNoteBlock.MIN_NOTE_VAL;
            }
            if (AdvancedNoteBlock.SUBTICK_LENGTH != packet.subtickLength()) {
                ANBInfoRender.SUBTICK_OFF_SYNC = true;
                AdvancedNoteBlock.SUBTICK_LENGTH = packet.subtickLength();
                AdvancedNoteBlock.SUBTICKS = (byte)(100.0f / (float)AdvancedNoteBlock.SUBTICK_LENGTH);
            }
            if (ANBInfoRender.SUBTICK_OFF_SYNC || ANBInfoRender.NOTE_OFF_SYNC) {
                Utils.sendDesyncWarning(context.player());
            }
        });
    }

    private static void handleActionPing(ActionPing packet, IPayloadContext context) {
        switch (ActionPing.Action.values()[packet.action()]) {
            case SAVE_STARTUP_CONFIG: {
                if (StartupConfig.UPDATED) break;
                StartupConfig.updateStartUpAndSave();
                context.player().displayClientMessage((Component)Component.translatable((String)"text.config.updated").withColor(Color.GREEN.darker().getRGB()), false);
                break;
            }
            case ACTIVATE_LOW_RES_RENDER: {
                if (!ClientConfig.LOW_RESOLUTION_RENDER.isFalse()) break;
                ClientConfig.LOW_RESOLUTION_RENDER.set((Object)true);
                context.player().displayClientMessage((Component)Component.translatable((String)"text.lowres.enable"), false);
                ClientConfig.CLIENT.save();
                break;
            }
            case DEACTIVATE_LOW_RES_RENDER: {
                if (!ClientConfig.LOW_RESOLUTION_RENDER.isTrue()) break;
                ClientConfig.LOW_RESOLUTION_RENDER.set((Object)false);
                context.player().displayClientMessage((Component)Component.translatable((String)"text.lowres.disable"), false);
                ClientConfig.CLIENT.save();
                break;
            }
            case LIST_CLIENT_CACHE: {
                for (String songInfo : SongCache.CLIENT_CACHE.getCachedSongInfo()) {
                    context.player().displayClientMessage((Component)Component.literal((String)("- " + songInfo.substring(40))).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, songInfo.substring(0, 36))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to copy ID (" + songInfo.substring(0, 36) + ")"))))), false);
                }
                break;
            }
        }
    }

    private static void handleScheduleCoreSound(ScheduleCoreSound sound, IPayloadContext context) {
        int data = sound.data();
        int sustainIndex = data & 0xFF;
        int noteVal = data >> 8 & 0xFF;
        int instrumentOrdinal = data >> 16 & 0xFF;
        boolean noDecay = (data >> 24 & 1) == 1;
        int delay = data >> 25 & 0x1F;
        AdvancedInstrument instrument = AdvancedInstrument.values()[instrumentOrdinal];
        SubTickScheduler.delayedCoredNoteBlockEvent(sound.pos(), sustainIndex, noteVal, sound.volume(), instrument, noDecay, delay);
    }

    private static void handleTunerData(TunerData data, IPayloadContext context) {
        Player player = context.player();
        FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems(player);
        if (!items.contains(TunerItem.class)) {
            return;
        }
        ItemStack stack = data.isInOffhand() ? (ItemStack)items.getB() : (ItemStack)items.getA();
        stack.set(Registry.TUNER_DATA, (Object)data);
    }

    private static void handleComposeData(ComposeData data, IPayloadContext context) {
        Player player = context.player();
        FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems(player);
        if (!items.contains((Item)Registry.COMPOSITION.get())) {
            return;
        }
        ItemStack stack = items.getFirst((Item)Registry.COMPOSITION.get());
        stack.set(Registry.COMPOSE_DATA, (Object)data);
    }

    private static void handleSongIDOnComposer(SongID data, IPayloadContext context) {
        ComposerContainer container;
        ServerPlayer player = (ServerPlayer)context.player();
        Object object = player.containerMenu;
        if (!(object instanceof ComposerContainer) || !((object = (container = (ComposerContainer)((Object)object)).getEntity()) instanceof ComposerBlockEntity)) {
            NoteBlockMaster.LOGGER.warn("Unable to determine ItemStack to save Song ID on");
            return;
        }
        Object BE = object;
        ItemStack composition = ((ComposerBlockEntity)((Object)BE)).getItem();
        if (composition.isEmpty() || !composition.is(Registry.COMPOSITION)) {
            NoteBlockMaster.LOGGER.warn("Unable to write Song ID onto invalid ItemStack at {}", (Object)BE.getBlockPos());
            return;
        }
        composition.set(Registry.SONG_ID, (Object)data);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ComposerBlockEntity.ClientItemUpdate(BE.getBlockPos(), Optional.of(composition), Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void handleSongIDInHand(SongID data, IPayloadContext context) {
        LocalPlayer player = (LocalPlayer)context.player();
        ItemStack composition = FinalTuple.getHeldItems((Player)player).getFirst((Item)Registry.COMPOSITION.get());
        if (composition.isEmpty()) {
            NoteBlockMaster.LOGGER.warn("Unable to write Song ID onto invalid ItemStack");
            return;
        }
        composition.set(Registry.SONG_ID, (Object)data);
    }

    private static void handleTickSchedule(TickSchedule tickSchedule, IPayloadContext context) {
        ServerLevel level = (ServerLevel)context.player().level();
        BlockPos pos = tickSchedule.pos();
        Utils.scheduleTick(level, pos, level.getBlockState(pos).getBlock(), tickSchedule.delay());
    }

    private static void handleCoreUpdate(CoreUpdate coreUpdate, IPayloadContext context) {
        Level level = context.player().level();
        BlockPos pos = coreUpdate.pos();
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)level.getBlockState(pos).setValue((Property)TuningCore.VOLUME, (Comparable)Integer.valueOf(coreUpdate.volume()))).setValue((Property)TuningCore.SUSTAIN, (Comparable)Integer.valueOf(coreUpdate.sustain())));
    }

    private static void handleLoadSong(LoadSong packet, IPayloadContext context) {
        NBS nbs = SongFileManager.loadNBSFile(packet.name());
        if (nbs != null) {
            SongData data = SongData.of(nbs);
            UUID ID = data.getID();
            context.player().displayClientMessage((Component)Component.literal((String)("Caching song " + data.title() + " by " + data.author() + " with ID " + String.valueOf(ID))).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ID.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy ID")))), false);
            SongCache.cacheSong(ID, data);
            return;
        }
        context.player().displayClientMessage((Component)Component.literal((String)("Could not load song " + packet.name() + ".nbs")), false);
    }
}

