/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.nayrus.noteblockmaster.block.TuningCore;
import net.nayrus.noteblockmaster.network.payload.TickSchedule;
import net.nayrus.noteblockmaster.render.NBMRenderType;
import net.nayrus.noteblockmaster.render.item.SpinningCoreRender;
import net.nayrus.noteblockmaster.render.utils.GeometryBuilder;
import net.nayrus.noteblockmaster.render.utils.RenderUtils;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.setup.config.ClientConfig;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

public class CoreRender {
    public static Map<BlockPos, Float> OFFSET_ON_POS = new HashMap<BlockPos, Float>();
    public static Map<BlockPos, Long> LAST_STAGE_TIME = new HashMap<BlockPos, Long>();
    public static final int CORE_RENDER_RANGE = 20;

    public static void renderCoresInRange(RenderLevelStageEvent e, Level level) {
        Vec3 camCenter = RenderUtils.getStableEyeCenter(Minecraft.getInstance().gameRenderer.getMainCamera());
        RenderLevelStageEvent.Stage stage = e.getStage();
        if (stage == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || stage == RenderLevelStageEvent.Stage.AFTER_WEATHER && !((Boolean)ClientConfig.LOW_RESOLUTION_RENDER.get()).booleanValue()) {
            for (BlockPos pos : RenderUtils.getTargetBlocks(level).cores()) {
                long renderTime;
                if (stage == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
                    renderTime = Util.getMillis();
                    LAST_STAGE_TIME.put(pos.immutable(), renderTime);
                } else {
                    renderTime = LAST_STAGE_TIME.getOrDefault(pos.immutable(), Util.getMillis());
                }
                CoreRender.renderCore(level, pos, level.getBlockState(pos), e.getPoseStack(), stage, Utils.exponentialFloor(0.5f, 20.0f, (float)RenderUtils.distanceVecToBlock(camCenter, pos), 2.0f), renderTime);
            }
        }
        if (stage == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            OFFSET_ON_POS.entrySet().removeIf(entry -> {
                BlockPos pos = (BlockPos)entry.getKey();
                if (!level.getBlockState(pos).is(Registry.TUNINGCORE)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new TickSchedule(pos, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return true;
                }
                return false;
            });
        }
    }

    public static void renderCore(Level level, BlockPos pos, BlockState state, PoseStack stack, RenderLevelStageEvent.Stage stage, float alpha, long time) {
        float halfShift;
        float animation;
        int steps;
        if (!state.is(Registry.TUNINGCORE)) {
            return;
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderUtils.pushAndTranslateRelativeToCam(stack);
        BlockPos immutablePos = pos.immutable();
        OFFSET_ON_POS.putIfAbsent(immutablePos, Float.valueOf(Math.abs(level.getRandom().nextFloat())));
        float anime = (float)time / 6.0f + OFFSET_ON_POS.get(immutablePos).floatValue();
        if (TuningCore.isMixing(state)) {
            int volume = (Integer)state.getValue((Property)TuningCore.VOLUME);
            steps = (int)(100.0 * (5.0 - 4.0 * (1.0 / (18.0 / (double)(19 - volume)))));
            animation = anime % (float)steps / ((float)steps * 2.0f);
            halfShift = (animation + 0.25f) % 0.5f;
            CoreRender.renderTorus(buffer, stack, stage, RenderUtils.applyAlpha(SpinningCoreRender.WOOL_COLOR, 1.0f), pos, (float)pos.getY() - 0.45f, 0.5f, alpha * CoreRender.getAlphaFactor(animation), 1.0f - animation * 1.8f, 0.05f);
            CoreRender.renderTorus(buffer, stack, stage, RenderUtils.applyAlpha(SpinningCoreRender.WOOL_COLOR, 1.0f), pos, (float)pos.getY() - 0.45f, 0.5f, alpha * CoreRender.getAlphaFactor(halfShift), 1.0f - halfShift * 1.8f, 0.05f);
        }
        if (TuningCore.isSustaining(state)) {
            int sustain = (Integer)state.getValue((Property)TuningCore.SUSTAIN);
            steps = (int)(100.0 * (double)(5.0f - 4.0f * (1.0f / ((float)TuningCore.SUSTAIN_MAXVAL / (float)sustain))));
            animation = anime % (float)steps / ((float)steps * 2.0f);
            halfShift = (animation + 0.25f) % 0.5f;
            CoreRender.renderTorus(buffer, stack, stage, RenderUtils.shiftColor(SpinningCoreRender.LAPIS_COLOR, Color.BLUE, 0.3f), pos, (float)pos.getY() - animation + 0.1f, 0.5f, alpha * CoreRender.getAlphaFactor(animation), 0.65f, 0.05f);
            CoreRender.renderTorus(buffer, stack, stage, RenderUtils.shiftColor(SpinningCoreRender.LAPIS_COLOR, Color.BLUE, 0.3f), pos, (float)pos.getY() - halfShift + 0.1f, 0.5f, alpha * CoreRender.getAlphaFactor(halfShift), 0.65f, 0.05f);
        }
        stack.popPose();
    }

    private static float getAlphaFactor(float animation) {
        float mid = Math.abs(animation - 0.25f);
        return (double)mid > 0.125 ? (0.25f - mid) * 8.0f : 1.0f;
    }

    public static void renderTorus(MultiBufferSource.BufferSource buffer, PoseStack matrix, RenderLevelStageEvent.Stage stage, Color color, BlockPos pos, float yPos, float scale, float alpha, float radius, float innerRadius) {
        matrix.pushPose();
        matrix.translate((float)pos.getX(), yPos, (float)pos.getZ());
        matrix.mulPose(Axis.YP.rotationDegrees(-90.0f));
        Matrix4f positionMatrix = matrix.last().pose();
        if (!((Boolean)ClientConfig.LOW_RESOLUTION_RENDER.get()).booleanValue()) {
            float offset = Utils.getRotationToX(pos.getCenter().subtract(RenderUtils.CURRENT_CAM_POS));
            int resolution = Math.max(32 - (int)RenderUtils.distanceVecToBlock(RenderUtils.CURRENT_CAM_POS, pos) * 4, 16);
            GeometryBuilder.buildHalfTorus(positionMatrix, buffer.getBuffer(NBMRenderType.TRANSLUCENT_QUADS), color, scale, radius, innerRadius, stage == RenderLevelStageEvent.Stage.AFTER_WEATHER ? offset : offset + (float)Math.PI, alpha, resolution % 2 == 0 ? resolution : resolution - 1);
        } else {
            GeometryBuilder.buildTorus(positionMatrix, buffer.getBuffer(NBMRenderType.TRANSLUCENT_QUADS), color, scale, radius, innerRadius, alpha, 4);
        }
        matrix.popPose();
    }

    public static void clearMaps() {
        OFFSET_ON_POS.entrySet().removeIf(entry -> {
            if (RenderUtils.distanceVecToBlock(RenderUtils.CURRENT_CAM_POS, (BlockPos)entry.getKey()) > 20.0) {
                LAST_STAGE_TIME.remove(entry.getKey());
                return true;
            }
            return false;
        });
    }
}

