/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.screen.base;

import java.math.BigDecimal;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.nayrus.noteblockmaster.utils.Utils;

public class BaseScreen
extends Screen {
    protected final ResourceLocation GUI;
    protected final int guiWidth;
    protected final int guiHeight;
    protected final int guiFileWidth;
    protected final int guiFileHeight;

    protected BaseScreen(ResourceLocation background, int guiWidth, int guiHeight, int guiFileWidth, int guiFileHeight) {
        super((Component)Component.literal((String)""));
        this.GUI = background;
        this.guiWidth = guiWidth;
        this.guiHeight = guiHeight;
        this.guiFileWidth = guiFileWidth;
        this.guiFileHeight = guiFileHeight;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(RenderType::guiTextured, this.GUI, this.getRelX(), this.getRelY(), 0.0f, 0.0f, this.guiWidth, this.guiHeight, this.guiFileWidth, this.guiFileHeight);
    }

    public int getRelX() {
        return (this.width - this.guiWidth) / 2;
    }

    public int getRelY() {
        return (this.height - this.guiHeight) / 2;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        if (!Utils.isIntInRange((int)mouseX, this.getRelX(), this.getRelX() + this.guiWidth) || !Utils.isIntInRange((int)mouseY, this.getRelY(), this.getRelY() + this.guiHeight)) {
            this.onClose();
        }
    }

    public BigDecimal getScrollFactor(boolean reduceOnAlt) {
        BigDecimal factor = BigDecimal.ONE;
        if (BaseScreen.hasShiftDown()) {
            factor = factor.multiply(BigDecimal.valueOf(2L));
        }
        if (BaseScreen.hasControlDown()) {
            factor = factor.multiply(BigDecimal.valueOf(5L));
        }
        if (BaseScreen.hasAltDown()) {
            factor = factor.multiply(BigDecimal.valueOf(reduceOnAlt ? 0.1 : 3.0));
        }
        return factor;
    }

    public BigDecimal getScrollFactor() {
        return this.getScrollFactor(true);
    }
}

