/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.screen.base;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.TunerData;
import net.nayrus.noteblockmaster.screen.base.BaseScreen;
import net.nayrus.noteblockmaster.screen.widget.IntegerEditBox;
import net.nayrus.noteblockmaster.screen.widget.ValueSlider;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.neoforge.network.PacketDistributor;

public class BaseTunerScreen
extends BaseScreen
implements Button.OnPress {
    protected IntegerEditBox input;
    protected Button add;
    protected Button set;
    protected ValueSlider slider;
    protected final ItemStack tuner;
    public int value;
    protected boolean setmode;
    protected final int maxValue;
    protected final boolean itemInOffhand;

    protected BaseTunerScreen(ItemStack item, int maxValue, boolean itemInOffhand) {
        super(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"textures/gui/tunerscreen.png"), 176, 53, 256, 256);
        this.tuner = item;
        this.maxValue = maxValue;
        this.itemInOffhand = itemInOffhand;
        TunerData data = TunerItem.getTunerData(item);
        this.value = data.value();
        this.setmode = data.isSetmode();
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int extend = this.getExtension();
        guiGraphics.blit(RenderType::guiTextured, this.GUI, this.getRelX() - extend / 2, this.getRelY(), 0.0f, 0.0f, this.guiWidth / 2, this.guiHeight, this.guiFileWidth, this.guiFileHeight);
        guiGraphics.blit(RenderType::guiTextured, this.GUI, this.getRelX() + this.guiWidth / 2 - extend / 2, this.getRelY(), 5.0f, 0.0f, extend > this.guiWidth - 5 ? extend / 2 : extend, this.guiHeight, this.guiFileWidth, this.guiFileHeight);
        if (extend > this.guiWidth - 5) {
            guiGraphics.blit(RenderType::guiTextured, this.GUI, this.getRelX() + this.guiWidth / 2, this.getRelY(), 5.0f, 0.0f, extend / 2, this.guiHeight, this.guiFileWidth, this.guiFileHeight);
        }
        guiGraphics.blit(RenderType::guiTextured, this.GUI, this.getRelX() + this.guiWidth / 2 + extend / 2, this.getRelY(), (float)(this.guiWidth / 2), 0.0f, this.guiWidth / 2, this.guiHeight, this.guiFileWidth, this.guiFileHeight);
    }

    public int getExtension() {
        return Math.max(0, this.maxValue - 20) * 4;
    }

    public void onPress(Button button) {
        button.setFocused(false);
        this.setmode = !this.setmode;
        this.updateButton();
    }

    protected void updateButton() {
        this.add.active = this.setmode;
        this.set.active = !this.setmode;
    }

    public void onClose() {
        TunerData _new = TunerData.of(this.value, this.setmode, this.itemInOffhand);
        this.tuner.set(Registry.TUNER_DATA, (Object)_new);
        PacketDistributor.sendToServer((CustomPacketPayload)_new, (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        int extend2 = this.getExtension() / 2;
        if (!Utils.isIntInRange((int)mouseX, this.getRelX() - extend2, this.getRelX() + this.guiWidth + extend2) || !Utils.isIntInRange((int)mouseY, this.getRelY(), this.getRelY() + this.guiHeight)) {
            this.onClose();
        }
    }
}

