/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.screen.widget;

import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class ValueSlider
extends AbstractSliderButton {
    private final Consumer<Double> callback;

    public ValueSlider(int x, int y, int width, int height, double value, Consumer<Double> callback) {
        super(x, y, width, height, (Component)Component.literal((String)""), value);
        this.callback = callback;
    }

    protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int width, int color) {
        int i = this.getX() + width;
        int j = this.getX() + this.getWidth() - width;
        ValueSlider.renderScrollingString(guiGraphics, font, this.getMessage(), i, this.getY(), j, this.getY() + this.getHeight(), color);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color) {
        int centerX = (minX + maxX) / 2;
        int i = font.width((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.getMillis() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.lerp((double)d2, (double)0.0, (double)l);
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            guiGraphics.drawString(font, text, minX - (int)d3, j, color);
            guiGraphics.disableScissor();
        } else {
            int i1 = Mth.clamp((int)centerX, (int)(minX + i / 2), (int)(maxX - i / 2));
            guiGraphics.drawCenteredString(font, text, i1, j, color);
        }
    }

    protected void updateMessage() {
    }

    protected void applyValue() {
        this.callback.accept(this.value);
    }

    public void setValue(double val) {
        this.value = val;
    }
}

