/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.setup;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.block.TuningCore;
import net.nayrus.noteblockmaster.composer.ComposerBlock;
import net.nayrus.noteblockmaster.composer.ComposerBlockEntity;
import net.nayrus.noteblockmaster.composer.ComposerContainer;
import net.nayrus.noteblockmaster.composer.ComposerRenderer;
import net.nayrus.noteblockmaster.composer.ComposerScreen;
import net.nayrus.noteblockmaster.item.ComposersNote;
import net.nayrus.noteblockmaster.item.SpinningCore;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.network.data.SongID;
import net.nayrus.noteblockmaster.network.data.TunerData;
import net.nayrus.noteblockmaster.render.item.CoreBaseRender;
import net.nayrus.noteblockmaster.render.item.SpinningCoreRender;
import net.nayrus.noteblockmaster.render.particle.SustainedNoteParticle;
import net.nayrus.noteblockmaster.render.particle.SustainedNoteType;
import net.nayrus.noteblockmaster.setup.ISpriteAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Registry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"noteblockmaster");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"noteblockmaster");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"noteblockmaster");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"noteblockmaster");
    public static final DeferredRegister.DataComponents DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"noteblockmaster");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"noteblockmaster");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"noteblockmaster");
    public static final DeferredBlock<Block> ADVANCED_NOTEBLOCK = BLOCKS.register("advanced_noteblock", AdvancedNoteBlock::new);
    public static final DeferredBlock<Block> TUNINGCORE = BLOCKS.register("tuningcore", TuningCore::new);
    public static final DeferredBlock<Block> COMPOSER = BLOCKS.register("composer", ComposerBlock::new);
    public static final Map<DeferredBlock<Block>, DeferredItem<Item>> BLOCK_ITEMS;
    public static final Supplier<BlockEntityType<ComposerBlockEntity>> COMPOSER_BE;
    public static final DeferredItem<Item> TEMPOTUNER;
    public static final DeferredItem<Item> NOTETUNER;
    public static final DeferredItem<Item> COMPOSITION;
    public static final DeferredItem<Item> CORE;
    public static final DeferredItem<Item> SUSTAIN;
    public static final DeferredItem<Item> VOLUME;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<TunerData>> TUNER_DATA;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ComposeData>> COMPOSE_DATA;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SongID>> SONG_ID;
    public static final DeferredHolder<ParticleType<?>, SustainedNoteType> SUSTAINED_NOTE;
    public static final Supplier<MenuType<ComposerContainer>> COMPOSER_MENU;

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        BLOCK_ENTITIES.register(eventBus);
        ITEMS.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
        DATA_COMPONENT_TYPES.register(eventBus);
        PARTICLE_TYPES.register(eventBus);
        MENU_TYPES.register(eventBus);
    }

    public static DeferredItem<Item> createBlockItem(DeferredBlock<Block> block) {
        return ITEMS.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)block.getId().getPath())))));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new SpinningCoreRender.Extension(), new Holder[]{VOLUME, SUSTAIN});
        event.registerItem((IClientItemExtensions)new CoreBaseRender.Extension(), new Holder[]{CORE});
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(COMPOSER_BE.get(), context -> new ComposerRenderer());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(COMPOSER_MENU.get(), ComposerScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        if (!(particleEngine instanceof ISpriteAccessor)) {
            return;
        }
        ISpriteAccessor vanillaSprites = (ISpriteAccessor)particleEngine;
        event.registerSpecial((ParticleType)SUSTAINED_NOTE.get(), (ParticleProvider)new SustainedNoteParticle.Provider(vanillaSprites.nbm$getRegisteredSprite((ParticleType<?>)ParticleTypes.NOTE)));
    }

    static {
        COMPOSER_BE = BLOCK_ENTITIES.register("composer_be", () -> new BlockEntityType(ComposerBlockEntity::new, new Block[]{(Block)COMPOSER.get()}));
        TEMPOTUNER = ITEMS.register("tempotuner", TunerItem::new);
        NOTETUNER = ITEMS.register("notetuner", TunerItem::new);
        COMPOSITION = ITEMS.register("composition", ComposersNote::new);
        CORE = ITEMS.register("core", () -> new Item(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"core")))));
        SUSTAIN = ITEMS.register("sustain", SpinningCore::new);
        VOLUME = ITEMS.register("volume", SpinningCore::new);
        TUNER_DATA = DATA_COMPONENT_TYPES.registerComponentType("tuner_data", builder -> builder.persistent(TunerData.TUNER_CODEC));
        COMPOSE_DATA = DATA_COMPONENT_TYPES.registerComponentType("compose_data", builder -> builder.persistent(ComposeData.CODEC));
        SONG_ID = DATA_COMPONENT_TYPES.registerComponentType("song_id", builder -> builder.persistent(SongID.CODEC));
        SUSTAINED_NOTE = PARTICLE_TYPES.register("sustained_note", () -> new SustainedNoteType(false));
        COMPOSER_MENU = MENU_TYPES.register("composer_menu", () -> new MenuType(ComposerContainer::new, FeatureFlags.DEFAULT_FLAGS));
        HashMap<DeferredBlock<Block>, DeferredItem<Item>> block_items = new HashMap<DeferredBlock<Block>, DeferredItem<Item>>();
        block_items.put(ADVANCED_NOTEBLOCK, Registry.createBlockItem(ADVANCED_NOTEBLOCK));
        BLOCK_ITEMS = block_items;
        CREATIVE_MODE_TABS.register("noteblockmaster", () -> CreativeModeTab.builder().title((Component)Component.literal((String)"Note Block Master")).icon(() -> new ItemStack((ItemLike)ADVANCED_NOTEBLOCK.asItem())).displayItems((pars, output) -> ITEMS.getEntries().forEach(item -> output.accept((ItemLike)item.get()))).build());
    }
}

