/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.sound;

import com.mojang.blaze3d.audio.Channel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.render.particle.IInternalParticleAccessor;
import net.nayrus.noteblockmaster.render.particle.SustainedNoteOptions;

public class CoreSound
extends SimpleSoundInstance {
    private final BlockPos immutablePos;
    private final int sustain;
    private final int noteVal;
    private final boolean mixing;
    private Channel channel;
    private Particle particle;

    public CoreSound(SoundEvent soundEvent, SoundSource source, float volume, int noteVal, RandomSource random, BlockPos pos, int sustain, boolean mixing) {
        super(soundEvent, source, mixing ? volume : 3.0f, AdvancedNoteBlock.getPitchFromNote(noteVal), random, pos);
        this.immutablePos = pos.immutable();
        this.sustain = sustain;
        this.noteVal = noteVal;
        this.mixing = mixing;
    }

    public void addNoteParticle() {
        LevelRenderer levelRenderer = Minecraft.getInstance().levelRenderer;
        if (!(levelRenderer instanceof IInternalParticleAccessor)) {
            return;
        }
        IInternalParticleAccessor levelRender = (IInternalParticleAccessor)levelRenderer;
        this.particle = levelRender.nbm$addInternalParticle(new SustainedNoteOptions((int)((float)this.sustain * (1.0f / this.getPitch()))), false, this.getX(), this.getY() + 0.7, this.getZ(), (float)(this.noteVal - 2) / 29.0f, 0.0, 0.0);
    }

    public BlockPos getImmutablePos() {
        return this.immutablePos;
    }

    public SoundInstance.Attenuation getAttenuation() {
        return this.mixing ? SoundInstance.Attenuation.NONE : SoundInstance.Attenuation.LINEAR;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Particle getParticle() {
        return this.particle;
    }
}

