/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.nayrus.noteblockmaster.datagen.NBMBlockLootTableProvider;
import net.nayrus.noteblockmaster.datagen.NBMBlockStateProvider;
import net.nayrus.noteblockmaster.datagen.NBMBlockTagProvider;
import net.nayrus.noteblockmaster.datagen.NBMItemModelProvider;
import net.nayrus.noteblockmaster.datagen.NBMItemTagProvider;
import net.nayrus.noteblockmaster.datagen.NBMLangProvider;
import net.nayrus.noteblockmaster.datagen.NBMRecipeProvider;
import net.nayrus.noteblockmaster.datagen.NBMSoundProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(NBMBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new NBMRecipeProvider(output, lookupProvider));
        NBMBlockTagProvider blockTagsProvider = new NBMBlockTagProvider(output, lookupProvider, helper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        gen.addProvider(event.includeServer(), (DataProvider)new NBMItemTagProvider(output, lookupProvider, blockTagsProvider.contentsGetter(), helper));
        gen.addProvider(event.includeClient(), (DataProvider)new NBMItemModelProvider(output, helper));
        gen.addProvider(event.includeClient(), (DataProvider)new NBMBlockStateProvider(output, helper));
        gen.addProvider(event.includeClient(), (DataProvider)new NBMSoundProvider(output, helper));
        gen.addProvider(event.includeClient(), (DataProvider)new NBMLangProvider(output));
    }
}

