/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.network;

import java.awt.Color;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.block.TuningCore;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.network.data.TunerData;
import net.nayrus.noteblockmaster.network.payload.ActionPing;
import net.nayrus.noteblockmaster.network.payload.ConfigCheck;
import net.nayrus.noteblockmaster.network.payload.CoreUpdate;
import net.nayrus.noteblockmaster.network.payload.RemoveBlockInfo;
import net.nayrus.noteblockmaster.network.payload.RequestBlockInfo;
import net.nayrus.noteblockmaster.network.payload.ScheduleCoreSound;
import net.nayrus.noteblockmaster.network.payload.SyncBlockInfos;
import net.nayrus.noteblockmaster.network.payload.TickSchedule;
import net.nayrus.noteblockmaster.render.ANBInfoRender;
import net.nayrus.noteblockmaster.render.utils.RenderUtils;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.setup.config.ClientConfig;
import net.nayrus.noteblockmaster.setup.config.StartupConfig;
import net.nayrus.noteblockmaster.sound.AdvancedInstrument;
import net.nayrus.noteblockmaster.sound.SubTickScheduler;
import net.nayrus.noteblockmaster.utils.FinalTuple;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketHandler {
    @SubscribeEvent
    public static void registerNetwork(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar reg = event.registrar("noteblockmaster");
        reg.playToClient(ConfigCheck.TYPE, ConfigCheck.STREAM_CODEC, PacketHandler::handleStartUpSync);
        reg.playToClient(ActionPing.TYPE, ActionPing.STREAM_CODEC, PacketHandler::handleActionPing);
        reg.playToClient(ScheduleCoreSound.TYPE, ScheduleCoreSound.STREAM_CODEC, PacketHandler::handleScheduleCoreSound);
        reg.playToClient(SyncBlockInfos.TYPE, SyncBlockInfos.STREAM_CODEC, RenderUtils::handleSyncPacket);
        reg.playToClient(RemoveBlockInfo.TYPE, RemoveBlockInfo.STREAM_CODEC, RenderUtils::handleRemovePacket);
        reg.playToServer(TunerData.TYPE, TunerData.TUNER_STREAM_CODEC, PacketHandler::handleTunerData);
        reg.playToServer(ComposeData.TYPE, ComposeData.STREAM_CODEC, PacketHandler::handleComposeData);
        reg.playToServer(TickSchedule.TYPE, TickSchedule.STREAM_CODEC, PacketHandler::handleTickSchedule);
        reg.playToServer(CoreUpdate.TYPE, CoreUpdate.STREAM_CODEC, PacketHandler::handleCoreUpdate);
        reg.playToServer(RequestBlockInfo.TYPE, RequestBlockInfo.STREAM_CODEC, PacketHandler::handleRequestBlockStates);
    }

    private static void handleStartUpSync(ConfigCheck packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (AdvancedNoteBlock.MIN_NOTE_VAL != packet.minNote() || AdvancedNoteBlock.MAX_NOTE_VAL != packet.maxNote()) {
                ANBInfoRender.NOTE_OFF_SYNC = true;
                AdvancedNoteBlock.MIN_NOTE_VAL = packet.minNote();
                AdvancedNoteBlock.MAX_NOTE_VAL = packet.maxNote();
                AdvancedNoteBlock.TOTAL_NOTES = AdvancedNoteBlock.MAX_NOTE_VAL - AdvancedNoteBlock.MIN_NOTE_VAL;
            }
            if (AdvancedNoteBlock.SUBTICK_LENGTH != packet.subtickLength()) {
                ANBInfoRender.SUBTICK_OFF_SYNC = true;
                AdvancedNoteBlock.SUBTICK_LENGTH = packet.subtickLength();
                AdvancedNoteBlock.SUBTICKS = (byte)(100.0f / (float)AdvancedNoteBlock.SUBTICK_LENGTH);
            }
            if (ANBInfoRender.SUBTICK_OFF_SYNC || ANBInfoRender.NOTE_OFF_SYNC) {
                Utils.sendDesyncWarning(context.player());
            }
        });
    }

    private static void handleActionPing(ActionPing packet, IPayloadContext context) {
        switch (ActionPing.Action.values()[packet.action()]) {
            case SAVE_STARTUP_CONFIG: {
                if (StartupConfig.UPDATED) break;
                StartupConfig.updateStartUpAndSave();
                context.player().sendSystemMessage((Component)Component.translatable((String)"text.config.updated").withColor(Color.GREEN.darker().getRGB()));
                break;
            }
            case ACTIVATE_LOW_RES_RENDER: {
                if (!ClientConfig.LOW_RESOLUTION_RENDER.isFalse()) break;
                ClientConfig.LOW_RESOLUTION_RENDER.set((Object)true);
                context.player().sendSystemMessage((Component)Component.translatable((String)"text.lowres.enable"));
                ClientConfig.CLIENT.save();
                break;
            }
            case DEACTIVATE_LOW_RES_RENDER: {
                if (!ClientConfig.LOW_RESOLUTION_RENDER.isTrue()) break;
                ClientConfig.LOW_RESOLUTION_RENDER.set((Object)false);
                context.player().sendSystemMessage((Component)Component.translatable((String)"text.lowres.disable"));
                ClientConfig.CLIENT.save();
            }
        }
    }

    private static void handleScheduleCoreSound(ScheduleCoreSound sound, IPayloadContext context) {
        int data = sound.data();
        int sustainIndex = data & 0xFF;
        int noteVal = data >> 8 & 0xFF;
        int instrumentOrdinal = data >> 16 & 0xFF;
        boolean noDecay = (data >> 24 & 1) == 1;
        int delay = data >> 25 & 0x1F;
        AdvancedInstrument instrument = AdvancedInstrument.values()[instrumentOrdinal];
        SubTickScheduler.delayedCoredNoteBlockEvent(sound.pos(), sustainIndex, noteVal, sound.volume(), instrument, noDecay, delay);
    }

    private static void handleTunerData(TunerData data, IPayloadContext context) {
        Player player = context.player();
        FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems(player);
        if (!items.contains(TunerItem.class)) {
            return;
        }
        ItemStack stack = data.isInOffhand() ? (ItemStack)items.getB() : (ItemStack)items.getA();
        stack.set(Registry.TUNER_DATA, (Object)data);
    }

    private static void handleComposeData(ComposeData data, IPayloadContext context) {
        Player player = context.player();
        FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems(player);
        if (!items.contains((Item)Registry.COMPOSER.get())) {
            return;
        }
        ItemStack stack = items.getFirst((Item)Registry.COMPOSER.get());
        stack.set(Registry.COMPOSE_DATA, (Object)data);
    }

    private static void handleTickSchedule(TickSchedule tickSchedule, IPayloadContext context) {
        ServerLevel level = (ServerLevel)context.player().level();
        BlockPos pos = tickSchedule.pos();
        Utils.scheduleTick(level, pos, level.getBlockState(pos).getBlock(), tickSchedule.delay());
    }

    private static void handleCoreUpdate(CoreUpdate coreUpdate, IPayloadContext context) {
        Level level = context.player().level();
        BlockPos pos = coreUpdate.pos();
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)level.getBlockState(pos).setValue((Property)TuningCore.VOLUME, (Comparable)Integer.valueOf(coreUpdate.volume()))).setValue((Property)TuningCore.SUSTAIN, (Comparable)Integer.valueOf(coreUpdate.sustain())));
    }

    private static void handleRequestBlockStates(RequestBlockInfo request, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        context.enqueueWork(() -> {
            HashMap<BlockPos, ANBInfoRender.BlockInfo> statesToSend = new HashMap<BlockPos, ANBInfoRender.BlockInfo>();
            ServerLevel level = (ServerLevel)player.level();
            for (BlockPos pos : request.positions()) {
                BlockState state;
                if (!level.isLoaded(pos) || !(state = level.getBlockState(pos)).is(Registry.ADVANCED_NOTEBLOCK)) continue;
                statesToSend.put(pos, new ANBInfoRender.BlockInfo(AdvancedNoteBlock.getNoteValue(state), (Integer)state.getValue((Property)AdvancedNoteBlock.SUBTICK)));
            }
            if (!statesToSend.isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncBlockInfos(statesToSend), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }
}

