/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.network.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.nayrus.noteblockmaster.setup.Registry;

public record ComposeData(int beat, int subtick, int postDelay, float bpm) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ComposeData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"composedata"));
    public static final Codec<ComposeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("beat").forGetter(ComposeData::beat), (App)Codec.INT.fieldOf("subtick").forGetter(ComposeData::subtick), (App)Codec.INT.fieldOf("delay").forGetter(ComposeData::postDelay), (App)Codec.FLOAT.fieldOf("bpm").forGetter(ComposeData::bpm)).apply((Applicative)instance, ComposeData::new));
    public static final StreamCodec<FriendlyByteBuf, ComposeData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ComposeData::beat, (StreamCodec)ByteBufCodecs.INT, ComposeData::subtick, (StreamCodec)ByteBufCodecs.INT, ComposeData::postDelay, (StreamCodec)ByteBufCodecs.FLOAT, ComposeData::bpm, ComposeData::new);

    public CustomPacketPayload.Type<ComposeData> type() {
        return TYPE;
    }

    public static ComposeData getComposeData(ItemStack stack) {
        ComposeData data = (ComposeData)stack.get(Registry.COMPOSE_DATA);
        if (data == null) {
            data = new ComposeData(0, 0, 1, 600.0f);
            stack.set(Registry.COMPOSE_DATA, (Object)data);
        }
        return data;
    }
}

