/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.render.NBMRenderType;
import net.nayrus.noteblockmaster.render.utils.GeometryBuilder;
import net.nayrus.noteblockmaster.render.utils.RenderUtils;
import net.nayrus.noteblockmaster.setup.config.ClientConfig;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ANBInfoRender {
    public static final int INFO_RENDER_RADIUS = 18;
    public static boolean NOTE_OFF_SYNC = false;
    public static boolean SUBTICK_OFF_SYNC = false;

    public static void renderNoteBlockInfo(RenderLevelStageEvent e, Level level, Utils.PROPERTY info) {
        RenderSystem.disableDepthTest();
        for (BlockPos pos : RenderUtils.getTargetBlocks((LevelAccessor)level).blocks()) {
            BlockInfo cachedInfo = RenderUtils.CACHED_BLOCK_INFO.get(pos);
            if (cachedInfo == null) continue;
            ANBInfoRender.renderNoteBlockInfo(e, pos, cachedInfo, info);
        }
    }

    public static void renderNoteBlockInfo(RenderLevelStageEvent e, BlockPos pos, BlockInfo cachedInfo, Utils.PROPERTY info) {
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        PoseStack matrix = e.getPoseStack();
        Color color = AdvancedNoteBlock.getColor(cachedInfo.noteVal(), cachedInfo.tickVal(), info);
        RenderUtils.pushAndTranslateRelativeToCam(matrix);
        float alpha = Utils.exponentialFloor(1.0f, 18.0f, (float)RenderUtils.distanceVecToBlock(RenderUtils.getStableEyeCenter(), pos), 4.0f);
        ANBInfoRender.renderColoredCone(buffer, matrix, color, pos, 0.2f, 0.33f * alpha);
        String text = switch (info) {
            default -> throw new MatchException(null, null);
            case Utils.PROPERTY.NOTE -> Utils.NOTE_STRING[cachedInfo.noteVal()];
            case Utils.PROPERTY.TEMPO -> Integer.toString(cachedInfo.tickVal());
        };
        ANBInfoRender.renderInfoLabel(buffer, matrix, text, color, pos, 0.025f, alpha);
        matrix.popPose();
    }

    public static void renderColoredCone(MultiBufferSource.BufferSource buffer, PoseStack matrix, Color color, BlockPos pos, float scale, float alpha) {
        matrix.pushPose();
        matrix.translate((float)pos.getX(), (float)pos.getY() + 0.7f, (float)pos.getZ());
        matrix.mulPose(Axis.YP.rotationDegrees(-90.0f));
        Matrix4f positionMatrix = matrix.last().pose();
        int resolution = (Boolean)ClientConfig.LOW_RESOLUTION_RENDER.get() != false ? 4 : Math.max(24 - (int)RenderUtils.distanceVecToBlock(RenderUtils.CURRENT_CAM_POS, pos) * 2, 8);
        GeometryBuilder.buildFlippedCone(positionMatrix, buffer.getBuffer(NBMRenderType.SEE_THROUGH_TRIANGLES), color, scale, alpha, resolution);
        matrix.popPose();
    }

    public static void renderInfoLabel(MultiBufferSource.BufferSource buffer, PoseStack matrix, String text, Color color, BlockPos pos, float scale, float alpha) {
        matrix.pushPose();
        matrix.translate((double)pos.getX() + 0.5, (double)((float)pos.getY() + 1.6f), (double)pos.getZ() + 0.5);
        ANBInfoRender.renderInfoText(buffer, matrix, pos, text, RenderUtils.applyAlpha(RenderUtils.shiftColor(color, Color.BLACK, 0.5f), alpha / 1.25f), scale, new Vector3f(-0.008f), 0);
        ANBInfoRender.renderInfoText(buffer, matrix, pos, text, RenderUtils.applyAlpha(RenderUtils.shiftColor(Color.LIGHT_GRAY, color, 0.8f), alpha), scale, new Vector3f(), 0);
        ANBInfoRender.renderInfoText(buffer, matrix, pos, " ".repeat(text.length() + 2), Color.BLACK, scale - 0.003f, new Vector3f(0.0f, 0.0f, -0.02f), RenderUtils.applyAlpha(RenderUtils.shiftColor(Color.WHITE, color, 0.33f), alpha / 3.0f).getRGB());
        matrix.popPose();
    }

    public static void renderInfoText(MultiBufferSource.BufferSource buffer, PoseStack matrix, BlockPos pos, String text, Color color, float scale, Vector3f offset, int background) {
        Font textRender = Minecraft.getInstance().font;
        Vec3 viewVec = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 1.6, (double)pos.getZ() + 0.5).subtract(RenderUtils.CURRENT_CAM_POS);
        matrix.pushPose();
        matrix.translate(-offset.x(), offset.y(), offset.z());
        ANBInfoRender.rotateTextToPlayer(matrix, (float)textRender.width(text) * scale / 2.0f, viewVec, offset);
        matrix.scale(scale, scale, scale);
        textRender.drawInBatch(text, 0.0f, 0.0f, color.getRGB(), false, matrix.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.SEE_THROUGH, background, 0xF000F0, false);
        matrix.popPose();
    }

    public static void rotateTextToPlayer(PoseStack matrix, float halfTextWidth, Vec3 viewVec, Vector3f offset) {
        double len = viewVec.length();
        matrix.mulPose(Axis.XP.rotationDegrees(180.0f));
        Quaternionf tilt = Axis.XP.rotation((float)(1.5707963267948966 * (viewVec.y() / len)));
        Quaternionf rotation = Axis.YP.rotation(Utils.getRotationToX(viewVec) + 1.5707964f);
        rotation.mul((Quaternionfc)tilt);
        matrix.rotateAround(rotation, offset.x(), offset.y(), offset.z());
        matrix.translate(-halfTextWidth, 0.0f, 0.0f);
    }

    public record BlockInfo(int noteVal, int tickVal) {
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, BlockInfo::noteVal, (StreamCodec)ByteBufCodecs.INT, BlockInfo::tickVal, BlockInfo::new);
    }
}

