/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.render.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.nayrus.noteblockmaster.render.particle.SustainedNoteOptions;

public class SustainedNoteParticle
extends TextureSheetParticle {
    protected SustainedNoteParticle(ClientLevel level, double x, double y, double z, double color, int lifetimeTicks) {
        super(level, x, y, z, 0.0, 0.05, 0.0);
        this.friction = Math.min(0.9f + (float)((double)0.1f / (2000.0 / Math.pow(lifetimeTicks, 1.5))), 1.0f);
        this.speedUpWhenYMotionIsBlocked = true;
        this.xd *= (double)0.005f;
        this.yd *= (double)0.01f;
        this.zd *= (double)0.005f;
        this.yd += 0.05 / (lifetimeTicks > 20 ? (double)lifetimeTicks / 16.0 : (double)lifetimeTicks / (10.0 + 10.0 * (double)lifetimeTicks / 16.0));
        this.rCol = Math.max(0.0f, Mth.sin((float)(((float)color + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.gCol = Math.max(0.0f, Mth.sin((float)(((float)color + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.bCol = Math.max(0.0f, Mth.sin((float)(((float)color + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.quadSize *= 1.5f;
        this.lifetime = lifetimeTicks;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float scaleFactor) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + scaleFactor) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public static class Provider
    implements ParticleProvider<SustainedNoteOptions> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SustainedNoteOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SustainedNoteParticle noteparticle = new SustainedNoteParticle(level, x, y, z, xSpeed, type.duration() / 50);
            noteparticle.pickSprite(this.sprite);
            return noteparticle;
        }
    }
}

