/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.sound;

import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.nayrus.noteblockmaster.sound.SustainedInstrument;

public enum AdvancedInstrument implements StringRepresentable
{
    HARP("harp", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_HARP),
    BASEDRUM("basedrum", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_BASEDRUM),
    SNARE("snare", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_SNARE),
    HAT("hat", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_HAT),
    BASS("bass", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_BASS),
    FLUTE("flute", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_FLUTE),
    BELL("bell", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_BELL),
    GUITAR("guitar", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_GUITAR),
    CHIME("chime", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_CHIME),
    XYLOPHONE("xylophone", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_XYLOPHONE),
    IRON_XYLOPHONE("iron_xylophone", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE),
    COW_BELL("cow_bell", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_COW_BELL),
    DIDGERIDOO("didgeridoo", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_DIDGERIDOO),
    BIT("bit", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_BIT),
    BANJO("banjo", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_BANJO),
    PLING("pling", (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_PLING);

    private final String name;
    private final Holder<SoundEvent> soundEvent;

    private AdvancedInstrument(String name, Holder<SoundEvent> soundEvent) {
        this.name = name;
        this.soundEvent = soundEvent;
    }

    public String getSerializedName() {
        return this.name;
    }

    public Holder<SoundEvent> getSoundEvent() {
        return this.soundEvent;
    }

    public SoundEvent getSustainedEvent(int sustain) {
        if (sustain == 0) {
            return (SoundEvent)this.getSoundEvent().value();
        }
        return SustainedInstrument.values()[this.ordinal()].getSoundEvent(sustain - 1);
    }

    public int getSustainTime(int sustain) {
        if (sustain == 0) {
            return 300;
        }
        return SustainedInstrument.values()[this.ordinal()].getSustainTime(sustain - 1);
    }

    public int getSustains() {
        return SustainedInstrument.values()[this.ordinal()].getSize();
    }
}

