/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.block;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.nayrus.noteblockmaster.block.TuningCore;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.TunerData;
import net.nayrus.noteblockmaster.render.ANBInfoRender;
import net.nayrus.noteblockmaster.setup.NBMTags;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.setup.config.StartupConfig;
import net.nayrus.noteblockmaster.sound.AdvancedInstrument;
import net.nayrus.noteblockmaster.sound.SubTickScheduler;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.NoteBlockEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;

public class AdvancedNoteBlock
extends Block {
    public static int SUBTICKS;
    public static int SUBTICK_LENGTH;
    public static final EnumProperty<AdvancedInstrument> INSTRUMENT;
    public static IntegerProperty SUBTICK;
    public static IntegerProperty NOTE;
    public static int MIN_NOTE_VAL;
    public static int MAX_NOTE_VAL;
    public static int TOTAL_NOTES;
    public static final int DEFAULT_NOTE;

    public AdvancedNoteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(INSTRUMENT, (Comparable)((Object)AdvancedInstrument.HARP))).setValue((Property)NoteBlock.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)SUBTICK, (Comparable)Integer.valueOf(0))).setValue((Property)NOTE, (Comparable)Integer.valueOf(DEFAULT_NOTE)));
    }

    public static void loadPropertiesFromConfig(NewRegistryEvent ignoredEvent) {
        SUBTICK_LENGTH = (Integer)StartupConfig.SUBTICK_LENGTH.get();
        SUBTICKS = (int)(100.0f / (float)SUBTICK_LENGTH);
        SUBTICK = IntegerProperty.create((String)"subtick", (int)0, (int)(SUBTICKS - 1));
        MIN_NOTE_VAL = StartupConfig.LOWER_NOTE_LIMIT.get() instanceof String ? AdvancedNoteBlock.noteStringAsInt((String)StartupConfig.LOWER_NOTE_LIMIT.get(), false) : (Integer)StartupConfig.LOWER_NOTE_LIMIT.get();
        MAX_NOTE_VAL = StartupConfig.HIGHER_NOTE_LIMIT.get() instanceof String ? AdvancedNoteBlock.noteStringAsInt((String)StartupConfig.HIGHER_NOTE_LIMIT.get(), false) : (Integer)StartupConfig.HIGHER_NOTE_LIMIT.get();
        NOTE = IntegerProperty.create((String)"note", (int)MIN_NOTE_VAL, (int)MAX_NOTE_VAL);
        TOTAL_NOTES = MAX_NOTE_VAL - MIN_NOTE_VAL;
    }

    private BlockState setInstrument(LevelAccessor level, BlockPos pos, BlockState state) {
        NoteBlockInstrument noteblockinstrument = level.getBlockState(pos.below()).instrument();
        AdvancedInstrument instrument = noteblockinstrument.worksAboveNoteBlock() ? AdvancedInstrument.HARP : AdvancedInstrument.values()[noteblockinstrument.ordinal()];
        BlockState above = level.getBlockState(pos.above());
        if (above.is(Registry.TUNINGCORE) && (Integer)above.getValue((Property)TuningCore.SUSTAIN) > instrument.getSustains()) {
            level.setBlock(pos.above(), (BlockState)above.setValue((Property)TuningCore.SUSTAIN, (Comparable)Integer.valueOf(instrument.getSustains())), 3);
        }
        return (BlockState)state.setValue(INSTRUMENT, (Comparable)((Object)instrument));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Block block;
        if (player.getWeaponItem().is(NBMTags.Items.TUNERS)) {
            if (!level.isClientSide()) {
                this.attack(state, level, pos, player);
            }
            return false;
        }
        if (!level.isClientSide() && (block = level.getBlockState(pos.above()).getBlock()) instanceof TuningCore) {
            TuningCore core = (TuningCore)block;
            Utils.scheduleTick((ServerLevel)level, pos.above(), (Block)core, 0);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        if (!player.getWeaponItem().is(NBMTags.Items.TUNERS)) {
            super.spawnDestroyParticles(level, player, pos, state);
        }
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return player.getWeaponItem().is(NBMTags.Items.TUNERS) ? 0.0f : super.getDestroyProgress(state, player, level, pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!(stack.is(NBMTags.Items.TUNERS) || stack.is(Registry.COMPOSER) || stack.is(NBMTags.Items.CORES))) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int val = AdvancedNoteBlock.getNoteValue(state);
        int _new = val + 1 >= DEFAULT_NOTE + 25 || val + 1 < DEFAULT_NOTE ? DEFAULT_NOTE : val + 1;
        return this.onNoteChange(level, player, state, pos, _new);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag = level.hasNeighborSignal(pos);
        if (flag != (Boolean)state.getValue((Property)NoteBlock.POWERED)) {
            if (flag) {
                this.playNote(null, level, pos);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)NoteBlock.POWERED, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public void playNote(@Nullable Entity entity, Level level, BlockPos pos) {
        BlockState stateAbove = level.getBlockState(pos.above());
        boolean isTuned = stateAbove.is(Registry.TUNINGCORE);
        if (!isTuned && !stateAbove.isAir()) {
            return;
        }
        level.blockEvent(pos, (Block)this, isTuned ? 1 : 0, 0);
        level.gameEvent(entity, (Holder)GameEvent.NOTE_BLOCK_PLAY, pos);
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.isClientSide) {
            ItemStack item = player.getWeaponItem();
            if (!item.is(NBMTags.Items.TUNERS)) {
                this.playNote((Entity)player, level, pos);
                player.awardStat(Stats.PLAY_NOTEBLOCK);
            } else {
                int new_val;
                TunerData data = TunerItem.getTunerData(item);
                if (item.is(Registry.NOTETUNER)) {
                    if (!player.isShiftKeyDown()) {
                        player.displayClientMessage((Component)Component.literal((String)Utils.NOTE_STRING[AdvancedNoteBlock.getNoteValue(state)]).withColor(AdvancedNoteBlock.getColor(state, Utils.PROPERTY.NOTE).getRGB()), true);
                        this.playNote((Entity)player, level, pos);
                        player.awardStat(Stats.PLAY_NOTEBLOCK);
                    } else {
                        new_val = data.setmode() ? data.value() + MIN_NOTE_VAL : this.changeNoteValueBy(state, -data.value());
                        this.onNoteChange(level, player, state, pos, new_val);
                    }
                }
                if (item.is(Registry.TEMPOTUNER)) {
                    if (!player.isShiftKeyDown()) {
                        player.displayClientMessage((Component)Component.literal((String)("(" + (Integer)state.getValue((Property)SUBTICK) * SUBTICK_LENGTH + " ms)")).withColor(AdvancedNoteBlock.getColor(state, Utils.PROPERTY.TEMPO).getRGB()), true);
                    } else {
                        int diff;
                        new_val = data.setmode() ? data.value() : ((diff = (Integer)state.getValue((Property)SUBTICK) - data.value()) < 0 ? diff + SUBTICKS : diff);
                        this.onSubtickChange(level, player, state, pos, new_val, false);
                    }
                }
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.setInstrument((LevelAccessor)context.getLevel(), context.getClickedPos(), this.defaultBlockState());
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        boolean flag = facing.getAxis() == Direction.Axis.Y;
        return flag ? this.setInstrument(level, currentPos, state) : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{INSTRUMENT, NoteBlock.POWERED, SUBTICK, NOTE});
    }

    protected boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        NoteBlockEvent.Play e = new NoteBlockEvent.Play(level, pos, state, AdvancedNoteBlock.getNoteValue(state), NoteBlockInstrument.values()[((AdvancedInstrument)((Object)state.getValue(INSTRUMENT))).ordinal()]);
        if (((NoteBlockEvent.Play)NeoForge.EVENT_BUS.post((Event)e)).isCanceled()) {
            return false;
        }
        AdvancedInstrument instrument = (AdvancedInstrument)((Object)state.getValue(INSTRUMENT));
        if (id == 0) {
            SubTickScheduler.delayedNoteBlockEvent(state, level, pos, instrument, 3.0f);
        }
        if (id >= 1) {
            SubTickScheduler.delayedCoredNoteBlockEvent(state, level.getBlockState(pos.above()), level, pos, instrument);
        }
        return true;
    }

    public static int noteStringAsInt(String note, boolean validate) {
        try {
            int num = Integer.parseInt(note);
            if (validate && !Utils.isIntInRange(num, MIN_NOTE_VAL, MAX_NOTE_VAL)) {
                throw new IllegalArgumentException("Note " + note + " is out of limited range " + MIN_NOTE_VAL + " ~ " + MAX_NOTE_VAL);
            }
            return num;
        }
        catch (NumberFormatException e) {
            note = note.toUpperCase();
            if (note.length() > 3 || note.length() < 2) {
                throw new IllegalArgumentException("Unexpected note format: Length not in range 2 ~ 3");
            }
            int val = note.length() == 3 ? 1 : 0;
            char key = note.charAt(0);
            switch (key) {
                case 'B': {
                    val += 2;
                }
                case 'A': {
                    val += 2;
                }
                case 'G': {
                    val += 2;
                }
                case 'F': {
                    ++val;
                }
                case 'E': {
                    val += 2;
                }
                case 'D': {
                    val += 2;
                }
                case 'C': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown key '" + key + "'");
                }
            }
            if ((val += (Character.getNumericValue(note.charAt(note.length() - 1)) - 1) * 12) < 0 || val >= Utils.NOTE_STRING.length) {
                throw new IllegalArgumentException("Note " + note + " is out of max range");
            }
            if (validate && !Utils.isIntInRange(val, MIN_NOTE_VAL, MAX_NOTE_VAL)) {
                throw new IllegalArgumentException("Note " + note + " is out of limited range " + MIN_NOTE_VAL + " ~ " + MAX_NOTE_VAL);
            }
            return val;
        }
    }

    public static int noteStringAsInt(String note) {
        return AdvancedNoteBlock.noteStringAsInt(note, true);
    }

    public static int getNoteValue(BlockState state) {
        return (Integer)state.getValue((Property)NOTE);
    }

    public BlockState setNoteValue(BlockState state, int value) {
        return (BlockState)state.setValue((Property)NOTE, (Comparable)Integer.valueOf(value %= Utils.NOTE_STRING.length));
    }

    public static float getPitchFromNote(int note) {
        return (float)Math.pow(2.0, (double)(note - 42) / 12.0);
    }

    public static Color getColor(BlockState state, Utils.PROPERTY info) {
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            switch (info) {
                case NOTE: {
                    if (ANBInfoRender.NOTE_OFF_SYNC) {
                        return Color.RED;
                    }
                }
                case TEMPO: {
                    if (!ANBInfoRender.SUBTICK_OFF_SYNC) break;
                    return Color.RED;
                }
            }
        }
        float rgbVal = switch (info) {
            default -> throw new MatchException(null, null);
            case Utils.PROPERTY.NOTE -> (float)(AdvancedNoteBlock.getNoteValue(state) - 2) / 29.0f;
            case Utils.PROPERTY.TEMPO -> (float)((Integer)state.getValue((Property)SUBTICK)).intValue() / ((float)SUBTICKS - 1.0f);
        };
        float rCol = Math.max(0.0f, Mth.sin((float)((rgbVal + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        float gCol = Math.max(0.0f, Mth.sin((float)((rgbVal + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        float bCol = Math.max(0.0f, Mth.sin((float)((rgbVal + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        return new Color(rCol, gCol, bCol);
    }

    public int changeNoteValueBy(BlockState state, int value) {
        int note = AdvancedNoteBlock.getNoteValue(state);
        int _new = note + value;
        if (_new >= note) {
            return _new <= MAX_NOTE_VAL ? _new : _new % MAX_NOTE_VAL - 1 + MIN_NOTE_VAL;
        }
        return _new >= MIN_NOTE_VAL ? _new : MAX_NOTE_VAL - MIN_NOTE_VAL % _new + 1;
    }

    public InteractionResult onNoteChange(Level level, Player player, BlockState state, BlockPos pos, int new_val) {
        int old_val = AdvancedNoteBlock.getNoteValue(state);
        int _new = CommonHooks.onNoteChange((Level)level, (BlockPos)pos, (BlockState)state, (int)old_val, (int)new_val);
        if (_new == -1) {
            return InteractionResult.FAIL;
        }
        state = this.setNoteValue(state, _new);
        level.setBlockAndUpdate(pos, state);
        this.playNote((Entity)player, level, pos);
        player.awardStat(Stats.TUNE_NOTEBLOCK);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onSubtickChange(Level level, Player player, BlockState state, BlockPos pos, int new_val, boolean add) {
        state = (BlockState)state.setValue((Property)SUBTICK, (Comparable)Integer.valueOf(new_val));
        level.setBlockAndUpdate(pos, state);
        level.playSound(null, pos, add ? SoundEvents.WOODEN_BUTTON_CLICK_ON : SoundEvents.WOODEN_BUTTON_CLICK_OFF, SoundSource.RECORDS, 1.0f, 1.0f);
        player.displayClientMessage((Component)Component.literal((String)("(" + new_val * SUBTICK_LENGTH + " ms)")).withColor(AdvancedNoteBlock.getColor(state, Utils.PROPERTY.TEMPO).getRGB()), true);
        return InteractionResult.SUCCESS;
    }

    static {
        INSTRUMENT = EnumProperty.create((String)"advanced_instrument", AdvancedInstrument.class);
        DEFAULT_NOTE = AdvancedNoteBlock.noteStringAsInt("F#3", false);
    }
}

