/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.utils.Utils;

public class BPMInfoCommand {
    public static final BlockState dummy = ((Block)Registry.ADVANCED_NOTEBLOCK.get()).defaultBlockState();

    public BPMInfoCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bpmcalc").then(Commands.argument((String)"bpm", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)(60000.0f / (float)AdvancedNoteBlock.SUBTICK_LENGTH))).executes(context -> {
            float bpm = FloatArgumentType.getFloat((CommandContext)context, (String)"bpm");
            int noteCount = 100;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> this.calculateTiming(bpm, noteCount), true);
            return 1;
        }))).executes(context -> 1));
    }

    private Component calculateTiming(float bpm, int noteCount) {
        float tPB = 60000.0f / bpm;
        MutableComponent com = Component.literal((String)"[0]").withColor(BPMInfoCommand.getColor(0));
        int lastTime = 0;
        for (int i = 1; i <= noteCount; ++i) {
            int noteTimeMs = (int)((float)i * tPB);
            int subTickTime = noteTimeMs % 100;
            int redClockTime = noteTimeMs - subTickTime;
            int subtick = (subTickTime - subTickTime % AdvancedNoteBlock.SUBTICK_LENGTH) / AdvancedNoteBlock.SUBTICK_LENGTH;
            if (redClockTime == lastTime) {
                com.append((Component)Component.literal((String)"-").withColor(Color.CYAN.getRGB())).append((Component)Component.literal((String)("[" + subtick + "]")).withColor(BPMInfoCommand.getColor(subtick)));
            } else {
                com.append((Component)Component.literal((String)"~").withColor(Color.GRAY.getRGB())).append((Component)Component.literal((String)String.valueOf((redClockTime - lastTime) / 100)).withColor(Color.WHITE.darker().getRGB())).append((Component)Component.literal((String)"~").withColor(Color.GRAY.getRGB()));
                com.append((Component)Component.literal((String)("[" + subtick + "]")).withColor(BPMInfoCommand.getColor(subtick)));
            }
            lastTime = redClockTime;
        }
        return com;
    }

    public static int getColor(int tick) {
        return AdvancedNoteBlock.getColor((BlockState)dummy.setValue((Property)AdvancedNoteBlock.SUBTICK, (Comparable)Integer.valueOf(tick)), Utils.PROPERTY.TEMPO).getRGB();
    }
}

