/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.nayrus.noteblockmaster.network.payload.ActionPing;
import net.nayrus.noteblockmaster.setup.config.ClientConfig;
import net.nayrus.noteblockmaster.setup.config.StartupConfig;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public class MainCommand {
    public static void mainCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nbm").then(MainCommand.saveConfigCommand())).then(MainCommand.lowResolutionCommand())).then(Commands.literal((String)"debug").executes(context -> 1))).executes(context -> -1));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> saveConfigCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"saveconfig").executes(context -> {
            if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
                if (!StartupConfig.UPDATED) {
                    StartupConfig.updateStartUpAndSave();
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"text.config.updated").withColor(Color.GREEN.darker().getRGB()), true);
                }
            } else {
                ServerPlayer patt0$temp = ((CommandSourceStack)context.getSource()).getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = patt0$temp;
                    ActionPing.sendActionPing(player, ActionPing.Action.SAVE_STARTUP_CONFIG);
                }
            }
            return 1;
        });
    }

    public static LiteralArgumentBuilder<CommandSourceStack> lowResolutionCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"improveFPS").then(Commands.argument((String)"activate", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
                boolean activate = BoolArgumentType.getBool((CommandContext)context, (String)"activate");
                if ((Boolean)ClientConfig.LOW_RESOLUTION_RENDER.get() != activate) {
                    ClientConfig.LOW_RESOLUTION_RENDER.set((Object)activate);
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)(activate ? "text.lowres.enable" : "text.lowres.disable")), true);
                    ClientConfig.CLIENT.save();
                }
            } else {
                ServerPlayer patt0$temp = ((CommandSourceStack)context.getSource()).getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = patt0$temp;
                    ActionPing.sendActionPing(player, BoolArgumentType.getBool((CommandContext)context, (String)"activate") ? ActionPing.Action.ACTIVATE_LOW_RES_RENDER : ActionPing.Action.DEACTIVATE_LOW_RES_RENDER);
                }
            }
            return 1;
        }))).executes(context -> {
            if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
                if (ClientConfig.LOW_RESOLUTION_RENDER.isFalse()) {
                    ClientConfig.LOW_RESOLUTION_RENDER.set((Object)true);
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"text.lowres.enable"), true);
                    ClientConfig.CLIENT.save();
                } else {
                    ServerPlayer patt0$temp = ((CommandSourceStack)context.getSource()).getPlayer();
                    if (patt0$temp instanceof ServerPlayer) {
                        ServerPlayer player = patt0$temp;
                        ActionPing.sendActionPing(player, ActionPing.Action.ACTIVATE_LOW_RES_RENDER);
                    }
                }
            }
            return 1;
        });
    }
}

