/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.datagen.recipes;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.nayrus.noteblockmaster.NoteBlockMaster;
import net.nayrus.noteblockmaster.item.TunerItem;

public class TunerRecipe
extends ShapedRecipe {
    public TunerRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainingItems = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.getItem() instanceof TunerItem) {
                remainingItems.set(i, (Object)ItemStack.EMPTY);
                continue;
            }
            if (stack.isEmpty() || !stack.hasCraftingRemainingItem()) continue;
            remainingItems.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return remainingItems;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)NoteBlockMaster.TUNER_RECIPE_SERIALIZER.get();
    }

    public HolderLookup.Provider getDummyProvider() {
        return new HolderLookup.Provider(this){

            public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                return Stream.empty();
            }

            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryKey) {
                return Optional.empty();
            }
        };
    }
}

