/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.datagen.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.nayrus.noteblockmaster.datagen.recipes.TunerRecipe;

public class TunerRecipeSerializer
implements RecipeSerializer<TunerRecipe> {
    public static final TunerRecipeSerializer INSTANCE = new TunerRecipeSerializer();
    public static final MapCodec<TunerRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340778_ -> p_340778_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.getResultItem(recipe.getDummyProvider())), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(ShapedRecipe::showNotification)).apply((Applicative)p_340778_, TunerRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TunerRecipe> STREAM_CODEC = StreamCodec.of(TunerRecipeSerializer::toNetwork, TunerRecipeSerializer::fromNetwork);

    public MapCodec<TunerRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, TunerRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static TunerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        String s = buffer.readUtf();
        CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
        ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
        ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        boolean flag = buffer.readBoolean();
        return new TunerRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, TunerRecipe recipe) {
        buffer.writeUtf(recipe.getGroup());
        buffer.writeEnum((Enum)recipe.category());
        ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultItem(recipe.getDummyProvider()));
        buffer.writeBoolean(recipe.showNotification());
    }
}

