/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.event;

import java.awt.Color;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.render.ANBInfoRender;
import net.nayrus.noteblockmaster.render.CoreRender;
import net.nayrus.noteblockmaster.render.utils.RenderUtils;
import net.nayrus.noteblockmaster.screen.ComposerScreen;
import net.nayrus.noteblockmaster.setup.NBMTags;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.sound.CoreSound;
import net.nayrus.noteblockmaster.sound.SubTickScheduler;
import net.nayrus.noteblockmaster.utils.FinalTuple;
import net.nayrus.noteblockmaster.utils.KeyBindings;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundSourceEvent;

public class ClientEvents {
    public static long ticks = 0L;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        while (((KeyMapping)KeyBindings.OPEN_OFFHAND_GUI.get()).consumeClick()) {
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (!(localPlayer instanceof Player)) {
                return;
            }
            LocalPlayer player = localPlayer;
            ItemStack off = player.getOffhandItem();
            if (off.is(NBMTags.Items.TUNERS)) {
                TunerItem.openTunerGUI(off, player.getMainHandItem());
            }
            if (!off.is(Registry.COMPOSER)) continue;
            Minecraft.getInstance().setScreen((Screen)new ComposerScreen(off));
        }
        if (ticks % 200L == 0L) {
            CoreRender.clearMaps();
        }
        ++ticks;
    }

    @SubscribeEvent
    public static void renderBlockOverlays(RenderLevelStageEvent e) {
        if (!RenderUtils.eventOnRelevantStage(e)) {
            return;
        }
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (!(localPlayer instanceof Player)) {
            return;
        }
        LocalPlayer player = localPlayer;
        RenderUtils.CURRENT_CAM_POS = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Level level = player.level();
        if (e.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems((Player)player);
            if (((ItemStack)items.getA()).is(NBMTags.Items.TUNERS)) {
                ANBInfoRender.renderNoteBlockInfo(e, level, ((ItemStack)items.getA()).is(Registry.NOTETUNER) ? Utils.PROPERTY.NOTE : Utils.PROPERTY.TEMPO);
            } else if (((ItemStack)items.getB()).is(NBMTags.Items.TUNERS)) {
                ANBInfoRender.renderNoteBlockInfo(e, level, ((ItemStack)items.getB()).is(Registry.NOTETUNER) ? Utils.PROPERTY.NOTE : Utils.PROPERTY.TEMPO);
            }
            if (items.contains((Item)Registry.COMPOSER.get())) {
                ItemStack composer = items.getFirst((Item)Registry.COMPOSER.get());
                ComposeData cData = ComposeData.getComposeData(composer);
                player.displayClientMessage((Component)Component.literal((String)("Repeater delay: " + cData.preDelay())).withColor(Color.RED.darker().getRGB()), true);
            }
        }
        CoreRender.renderCoresInRange(e, level);
    }

    @SubscribeEvent
    public static void playSoundSourceEvent(PlaySoundSourceEvent e) {
        SoundInstance soundInstance = e.getSound();
        if (!(soundInstance instanceof CoreSound)) {
            return;
        }
        CoreSound sound = (CoreSound)soundInstance;
        SubTickScheduler.SUSTAINED_SOUNDS.put(sound.getImmutablePos(), sound);
        sound.addNoteParticle();
        sound.setChannel(e.getChannel());
    }
}

