/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.screen.ComposerScreen;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.utils.Utils;

public class ComposersNote
extends Item {
    public ComposersNote() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (!(player instanceof Player)) {
            return InteractionResult.FAIL;
        }
        Player player2 = player;
        Item item = player2.getOffhandItem().getItem();
        if (item instanceof TunerItem) {
            BlockPos pos;
            TunerItem item2 = (TunerItem)item;
            Level level = context.getLevel();
            BlockState state = level.getBlockState(pos = context.getClickedPos());
            if (state.getBlock() instanceof AdvancedNoteBlock) {
                return item2.useOn(context, true);
            }
            ItemStack tuner = player2.getOffhandItem();
            Inventory inv = player2.getInventory();
            if (player2.isShiftKeyDown()) {
                return InteractionResult.PASS;
            }
            if (tuner.is(Registry.TEMPOTUNER) && inv.contains(stack -> stack.is(Items.REPEATER))) {
                return ComposersNote.placeRepeater(context, player2, level, pos, inv);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult placeRepeater(UseOnContext context, Player player, Level level, BlockPos pos, Inventory inv) {
        ItemStack composer = context.getItemInHand();
        ComposeData cData = ComposeData.getComposeData(composer);
        int target = cData.preDelay();
        int set = Math.min(target, 4);
        if (target > 0) {
            target -= set;
            if (!level.isClientSide()) {
                level.setBlock(pos.above(), (BlockState)((BlockState)Blocks.REPEATER.defaultBlockState().setValue((Property)RepeaterBlock.DELAY, (Comparable)Integer.valueOf(set))).setValue((Property)RepeaterBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite()), 3);
                composer.set(Registry.COMPOSE_DATA, (Object)new ComposeData(cData.beat(), cData.subtick(), target, cData.bpm()));
                level.playSound(null, pos, SoundType.STONE.getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
                if (!player.isCreative()) {
                    Utils.removeItemsFromInventory(inv, Items.REPEATER, 1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (level.isClientSide()) {
            Utils.playFailUse(level, player, pos);
        }
        return InteractionResult.FAIL;
    }

    public static Tuple<Integer, Integer> subtickAndPauseOnBeat(int beat, float bpm) {
        float tPB = 60000.0f / bpm;
        int current_subtick = 0;
        int pre_delay = 0;
        int lastTime = 0;
        for (int i = beat - 1; i <= beat; ++i) {
            int noteTimeMs = (int)((float)i * tPB);
            int subTickTime = noteTimeMs % 100;
            int redClockTime = noteTimeMs - subTickTime;
            int subtick = (subTickTime - subTickTime % AdvancedNoteBlock.SUBTICK_LENGTH) / AdvancedNoteBlock.SUBTICK_LENGTH;
            if (i == beat) {
                current_subtick = subtick;
                pre_delay = (redClockTime - lastTime) / 100;
            }
            lastTime = redClockTime;
        }
        return new Tuple((Object)current_subtick, (Object)pre_delay);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack item = player.getItemInHand(usedHand);
        if (level.isClientSide()) {
            Minecraft.getInstance().setScreen((Screen)new ComposerScreen(item));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
    }
}

