/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.network;

import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.block.TuningCore;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.network.data.TunerData;
import net.nayrus.noteblockmaster.network.payload.ActionPing;
import net.nayrus.noteblockmaster.network.payload.ConfigCheck;
import net.nayrus.noteblockmaster.network.payload.CoreUpdate;
import net.nayrus.noteblockmaster.network.payload.TickSchedule;
import net.nayrus.noteblockmaster.render.ANBInfoRender;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.setup.config.ClientConfig;
import net.nayrus.noteblockmaster.setup.config.StartupConfig;
import net.nayrus.noteblockmaster.utils.FinalTuple;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketHandler {
    @SubscribeEvent
    public static void registerNetwork(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar reg = event.registrar("noteblockmaster");
        reg.playToClient(ConfigCheck.TYPE, ConfigCheck.STREAM_CODEC, PacketHandler::handleStartUpSync);
        reg.playToClient(ActionPing.TYPE, ActionPing.STREAM_CODEC, PacketHandler::handleActionPing);
        reg.playToServer(TunerData.TYPE, TunerData.TUNER_STREAM_CODEC, PacketHandler::handleTunerData);
        reg.playToServer(ComposeData.TYPE, ComposeData.STREAM_CODEC, PacketHandler::handleComposeData);
        reg.playToServer(TickSchedule.TYPE, TickSchedule.STREAM_CODEC, PacketHandler::handleTickSchedule);
        reg.playToServer(CoreUpdate.TYPE, CoreUpdate.STREAM_CODEC, PacketHandler::handleCoreUpdate);
    }

    private static void handleStartUpSync(ConfigCheck packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (AdvancedNoteBlock.MIN_NOTE_VAL != packet.minNote() || AdvancedNoteBlock.MAX_NOTE_VAL != packet.maxNote()) {
                ANBInfoRender.NOTE_OFF_SYNC = true;
                AdvancedNoteBlock.MIN_NOTE_VAL = packet.minNote();
                AdvancedNoteBlock.MAX_NOTE_VAL = packet.maxNote();
                AdvancedNoteBlock.TOTAL_NOTES = AdvancedNoteBlock.MAX_NOTE_VAL - AdvancedNoteBlock.MIN_NOTE_VAL;
            }
            if (AdvancedNoteBlock.SUBTICK_LENGTH != packet.subtickLength()) {
                ANBInfoRender.SUBTICK_OFF_SYNC = true;
                AdvancedNoteBlock.SUBTICK_LENGTH = packet.subtickLength();
                AdvancedNoteBlock.SUBTICKS = (byte)(100.0f / (float)AdvancedNoteBlock.SUBTICK_LENGTH);
            }
            if (ANBInfoRender.SUBTICK_OFF_SYNC || ANBInfoRender.NOTE_OFF_SYNC) {
                Utils.sendDesyncWarning(context.player());
            }
        });
    }

    private static void handleActionPing(ActionPing packet, IPayloadContext context) {
        switch (ActionPing.Action.values()[packet.action()]) {
            case SAVE_STARTUP_CONFIG: {
                if (StartupConfig.UPDATED) break;
                StartupConfig.updateStartUpAndSave();
                context.player().sendSystemMessage((Component)Component.translatable((String)"text.config.updated").withColor(Color.GREEN.darker().getRGB()));
                break;
            }
            case ACTIVATE_LOW_RES_RENDER: {
                if (!ClientConfig.LOW_RESOLUTION_RENDER.isFalse()) break;
                ClientConfig.LOW_RESOLUTION_RENDER.set((Object)true);
                context.player().sendSystemMessage((Component)Component.translatable((String)"text.lowres.enable"));
                ClientConfig.CLIENT.save();
                break;
            }
            case DEACTIVATE_LOW_RES_RENDER: {
                if (!ClientConfig.LOW_RESOLUTION_RENDER.isTrue()) break;
                ClientConfig.LOW_RESOLUTION_RENDER.set((Object)false);
                context.player().sendSystemMessage((Component)Component.translatable((String)"text.lowres.disable"));
                ClientConfig.CLIENT.save();
            }
        }
    }

    private static void handleTunerData(TunerData data, IPayloadContext context) {
        Player player = context.player();
        FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems(player);
        if (!items.contains(TunerItem.class)) {
            return;
        }
        ItemStack stack = items.getFirst(TunerItem.class);
        stack.set(Registry.TUNER_DATA, (Object)data);
    }

    private static void handleComposeData(ComposeData data, IPayloadContext context) {
        Player player = context.player();
        FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems(player);
        if (!items.contains((Item)Registry.COMPOSER.get())) {
            return;
        }
        ItemStack stack = items.getFirst((Item)Registry.COMPOSER.get());
        stack.set(Registry.COMPOSE_DATA, (Object)data);
    }

    public static void handleTickSchedule(TickSchedule tickSchedule, IPayloadContext context) {
        ServerLevel level = (ServerLevel)context.player().level();
        BlockPos pos = tickSchedule.pos();
        Utils.scheduleTick(level, pos, level.getBlockState(pos).getBlock(), tickSchedule.delay());
    }

    public static void handleCoreUpdate(CoreUpdate coreUpdate, IPayloadContext context) {
        Level level = context.player().level();
        BlockPos pos = coreUpdate.pos();
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)level.getBlockState(pos).setValue((Property)TuningCore.VOLUME, (Comparable)Integer.valueOf(coreUpdate.volume()))).setValue((Property)TuningCore.SUSTAIN, (Comparable)Integer.valueOf(coreUpdate.sustain())));
    }
}

