/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class BaseItemRender
extends BlockEntityWithoutLevelRenderer {
    public BaseItemRender() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        matrix.pushPose();
        matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
        switch (displayContext) {
            case NONE: {
                break;
            }
            case GUI: {
                this.renderItemInGUI(stack, matrix, buffer, packedLight, packedOverlay);
                break;
            }
            case GROUND: {
                this.renderItemOnGround(stack, matrix, buffer, packedLight, packedOverlay);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                this.renderItemFirstPerson(stack, matrix, buffer, packedLight, packedOverlay, InteractionHand.MAIN_HAND);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                this.renderItemFirstPerson(stack, matrix, buffer, packedLight, packedOverlay, InteractionHand.OFF_HAND);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                this.renderItemThirdPerson(stack, matrix, buffer, packedLight, packedOverlay, InteractionHand.MAIN_HAND);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                this.renderItemThirdPerson(stack, matrix, buffer, packedLight, packedOverlay, InteractionHand.OFF_HAND);
                break;
            }
            case FIXED: {
                this.renderItemInFrame(stack, matrix, buffer, packedLight, packedOverlay);
                break;
            }
            case HEAD: {
                this.renderItemOnHead(stack, matrix, buffer, packedLight, packedOverlay);
            }
        }
        matrix.popPose();
    }

    public abstract void renderItemInGUI(ItemStack var1, PoseStack var2, MultiBufferSource var3, int var4, int var5);

    public abstract void renderItemOnGround(ItemStack var1, PoseStack var2, MultiBufferSource var3, int var4, int var5);

    public abstract void renderItemFirstPerson(ItemStack var1, PoseStack var2, MultiBufferSource var3, int var4, int var5, InteractionHand var6);

    public abstract void renderItemThirdPerson(ItemStack var1, PoseStack var2, MultiBufferSource var3, int var4, int var5, InteractionHand var6);

    public abstract void renderItemInFrame(ItemStack var1, PoseStack var2, MultiBufferSource var3, int var4, int var5);

    public abstract void renderItemOnHead(ItemStack var1, PoseStack var2, MultiBufferSource var3, int var4, int var5);
}

