/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.Util;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.nayrus.noteblockmaster.render.NBMRenderType;
import net.nayrus.noteblockmaster.render.item.BaseItemRender;
import net.nayrus.noteblockmaster.render.utils.CircularColorGradient;
import net.nayrus.noteblockmaster.render.utils.GeometryBuilder;
import net.nayrus.noteblockmaster.render.utils.RenderUtils;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class CoreBaseRender
extends BaseItemRender {
    public static final CircularColorGradient ENDER_GRADIENT;
    public static final CircularColorGradient IRON_GRADIENT;
    public static final CircularColorGradient BLAZE_GRADIENT;

    @Override
    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        super.renderByItem(stack, displayContext, matrix, buffer, packedLight, packedOverlay);
    }

    @Override
    public void renderItemInGUI(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        CoreBaseRender.renderBaseRings(matrix, buffer, 0.45f, packedLight, 32);
    }

    @Override
    public void renderItemOnGround(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Entity entity = stack.getEntityRepresentation();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity e = (ItemEntity)entity;
        double distance = RenderUtils.distanceVecToBlock(RenderUtils.CURRENT_CAM_POS, e.getOnPos());
        CoreBaseRender.renderBaseRings(matrix, buffer, 0.25f, packedLight, Math.max(48 - (int)(36.0 * distance / 16.0), 12));
    }

    @Override
    public void renderItemFirstPerson(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay, InteractionHand hand) {
        matrix.translate(0.0, 0.0, -0.15);
        matrix.rotateAround(Axis.ZP.rotation(hand == InteractionHand.MAIN_HAND ? 0.25f : -0.25f), 0.5f, 0.5f, 0.0f);
        CoreBaseRender.renderBaseRings(matrix, buffer, 0.25f, packedLight, 64);
    }

    @Override
    public void renderItemThirdPerson(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay, InteractionHand hand) {
        matrix.translate(0.0, 0.0, -0.2);
        CoreBaseRender.renderBaseRings(matrix, buffer, 0.25f, packedLight, 64);
    }

    @Override
    public void renderItemInFrame(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Entity entity = stack.getEntityRepresentation();
        if (!(entity instanceof Entity)) {
            return;
        }
        Entity e = entity;
        double distance = RenderUtils.distanceVecToBlock(RenderUtils.CURRENT_CAM_POS, e.getOnPos());
        CoreBaseRender.renderBaseRings(matrix, buffer, 0.45f, packedLight, Math.max(64 - (int)(56.0 * distance / 20.0), 8));
    }

    @Override
    public void renderItemOnHead(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        CoreBaseRender.renderBaseRings(matrix, buffer, 0.45f, packedLight, 32);
    }

    public static void renderBaseRings(PoseStack matrix, MultiBufferSource buffer, float scale, int packedLight, int resolution) {
        matrix.pushPose();
        matrix.rotateAround(Axis.YP.rotation((float)Util.getMillis() / 600.0f), 0.5f, 0.0f, -0.5f);
        matrix.rotateAround(Axis.ZP.rotation(Mth.sin((float)((float)Util.getMillis() / 600.0f)) * Mth.cos((float)((float)Util.getMillis() / -600.0f)) / 10.0f), 0.5f, 0.5f, 0.0f);
        GeometryBuilder.buildTorusWithGradient(matrix.last().pose(), buffer.getBuffer(NBMRenderType.TRANSLUCENT_QUADS), scale, 0.45f, 0.045f, 0.0f, resolution, ENDER_GRADIENT);
        matrix.popPose();
        matrix.pushPose();
        matrix.rotateAround(Axis.YP.rotation((float)Util.getMillis() / -3000.0f), 0.5f, 0.0f, -0.5f);
        GeometryBuilder.buildTorusWithGradient(matrix.last().pose(), buffer.getBuffer(NBMRenderType.TRANSLUCENT_QUADS), scale, 0.6f, 0.11f, 0.0f, resolution, IRON_GRADIENT);
        matrix.popPose();
        matrix.pushPose();
        matrix.rotateAround(Axis.YP.rotation((float)Util.getMillis() / -700.0f), 0.5f, 0.0f, -0.5f);
        matrix.rotateAround(Axis.ZP.rotation(Mth.sin((float)((float)Util.getMillis() / -700.0f)) * Mth.cos((float)((float)Util.getMillis() / 700.0f)) / 10.0f), 0.5f, 0.5f, 0.0f);
        GeometryBuilder.buildTorusWithGradient(matrix.last().pose(), buffer.getBuffer(NBMRenderType.TRANSLUCENT_QUADS), scale, 0.75f, 0.045f, 0.0f, resolution, BLAZE_GRADIENT);
        matrix.popPose();
    }

    static {
        int alpha = 179;
        int alphaIron = 205;
        float[] point = new float[32];
        for (int i = 0; i < 32; ++i) {
            point[i] = (float)i * (float)Math.PI / 16.0f;
        }
        Color ender = new Color(52, 153, 136, alpha);
        Color enderDark = new Color(16, 94, 81, alpha);
        Color enderDarker = new Color(11, 77, 66, alpha);
        Color enderBright = new Color(44, 205, 177, alpha);
        Color enderWhite = new Color(140, 244, 226, alpha);
        Color enderBlack = new Color(3, 38, 32, alpha);
        Color iron = new Color(216, 216, 216, alphaIron);
        Color ironGray = new Color(168, 168, 168, alphaIron);
        Color ironDark = new Color(114, 114, 114, alphaIron);
        Color ironWhite = RenderUtils.applyAlpha(Color.WHITE, (float)alphaIron / 255.0f);
        Color blazeOrange = new Color(255, 163, 0, alpha);
        Color blazeGold = new Color(255, 224, 0, alpha);
        Color blazeYellow = new Color(255, 254, 49, alpha);
        Color blazeWhite = new Color(255, 255, 181, alpha);
        ENDER_GRADIENT = new CircularColorGradient.Builder().addColor(point[0], ender).addColor(point[2], enderDarker).addColor(point[5], enderDark).addColor(point[6], ender).addColor(point[8], enderDark).addColor(point[10], enderBlack).addColor(point[11], enderDarker).addColor(point[13], ender).addColor(point[14], enderBright).addColor(point[15], enderWhite).addColor(point[17], enderBright).addColor(point[19], enderDark).addColor(point[21], ender).addColor(point[24], enderDark).addColor(point[25], ender).addColor(point[27], enderBright).addColor(point[29], enderWhite).addColor(point[31], enderDark).build();
        IRON_GRADIENT = new CircularColorGradient.Builder().addColor(point[0], iron).addColor(point[6], iron).addColor(point[8], ironWhite).addColor(point[9], iron).addColor(point[12], ironGray).addColor(point[14], ironDark).addColor(point[15], ironDark).addColor(point[17], ironGray).addColor(point[20], iron).addColor(point[24], iron).addColor(point[26], ironWhite).addColor(point[28], iron).addColor(point[29], ironGray).addColor(point[31], ironGray).build();
        BLAZE_GRADIENT = new CircularColorGradient.Builder().addColor(point[1], blazeWhite).addColor(point[2], blazeOrange).addColor(point[4], blazeYellow).addColor(point[5], blazeWhite).addColor(point[6], blazeGold).addColor(point[10], blazeOrange).addColor(point[14], blazeOrange).addColor(point[18], blazeGold).addColor(point[23], blazeYellow).addColor(point[24], blazeWhite).addColor(point[27], blazeOrange).addColor(point[30], blazeGold).build();
    }

    public static class Extension
    implements IClientItemExtensions {
        private final BaseItemRender baseItemRender = new CoreBaseRender();

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return this.baseItemRender;
        }
    }
}

