/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.Util;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.nayrus.noteblockmaster.render.NBMRenderType;
import net.nayrus.noteblockmaster.render.item.BaseItemRender;
import net.nayrus.noteblockmaster.render.item.CoreBaseRender;
import net.nayrus.noteblockmaster.render.utils.CircularColorGradient;
import net.nayrus.noteblockmaster.render.utils.GeometryBuilder;
import net.nayrus.noteblockmaster.render.utils.RenderUtils;
import net.nayrus.noteblockmaster.setup.Registry;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class SpinningCoreRender
extends BaseItemRender {
    public static final CircularColorGradient LAPIS;
    public static final CircularColorGradient WOOL;
    public static final Color LAPIS_COLOR;
    public static final Color WOOL_COLOR;

    @Override
    public void renderItemInGUI(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.renderRotatingRings(matrix, buffer, this.getColorGradient(stack), 0.45f, packedLight, 32);
    }

    @Override
    public void renderItemOnGround(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Entity entity = stack.getEntityRepresentation();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity e = (ItemEntity)entity;
        double distance = RenderUtils.distanceVecToBlock(RenderUtils.CURRENT_CAM_POS, e.getOnPos());
        this.renderRotatingRings(matrix, buffer, this.getColorGradient(stack), 0.3f, packedLight, Math.max(40 - (int)(36.0 * distance / 16.0), 12));
    }

    @Override
    public void renderItemFirstPerson(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay, InteractionHand hand) {
        matrix.translate(0.0, 0.0, -0.2);
        this.renderRotatingRings(matrix, buffer, this.getColorGradient(stack), 0.3f, packedLight, 48);
    }

    @Override
    public void renderItemThirdPerson(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay, InteractionHand hand) {
        matrix.translate(0.0, 0.0, -0.25);
        this.renderRotatingRings(matrix, buffer, this.getColorGradient(stack), 0.3f, packedLight, 48);
    }

    @Override
    public void renderItemInFrame(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Entity entity = stack.getEntityRepresentation();
        if (!(entity instanceof Entity)) {
            return;
        }
        Entity e = entity;
        double distance = RenderUtils.distanceVecToBlock(RenderUtils.CURRENT_CAM_POS, e.getOnPos());
        this.renderRotatingRings(matrix, buffer, this.getColorGradient(stack), 0.45f, packedLight, Math.max(64 - (int)(56.0 * distance / 20.0), 8));
    }

    @Override
    public void renderItemOnHead(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.renderItemInGUI(stack, matrix, buffer, packedLight, packedOverlay);
    }

    public void renderRotatingRings(PoseStack matrix, MultiBufferSource buffer, CircularColorGradient gradient, float scale, int packedLight, int resolution) {
        matrix.pushPose();
        matrix.rotateAround(Axis.YP.rotation((float)Util.getMillis() / 1500.0f), 0.5f, 0.0f, -0.5f);
        matrix.rotateAround(Axis.XP.rotation((float)Util.getMillis() / 700.0f), 0.0f, 0.5f, -0.5f);
        GeometryBuilder.buildTorusWithGradient(matrix.last().pose(), buffer.getBuffer(NBMRenderType.TRANSLUCENT_QUADS), scale, 0.7f, 0.08f, 0.0f, resolution, gradient);
        matrix.popPose();
        matrix.pushPose();
        matrix.rotateAround(Axis.XP.rotation((float)Util.getMillis() / 3000.0f), 0.0f, 0.5f, -0.5f);
        matrix.rotateAround(Axis.ZP.rotation((float)Util.getMillis() / 500.0f), 0.5f, 0.5f, 0.0f);
        matrix.rotateAround(Axis.YP.rotation((float)(-Util.getMillis()) / 1000.0f), 0.5f, 0.0f, -0.5f);
        GeometryBuilder.buildTorusWithGradient(matrix.last().pose(), buffer.getBuffer(NBMRenderType.TRANSLUCENT_QUADS), scale, 0.6f, 0.02f, 0.0f, resolution, CoreBaseRender.IRON_GRADIENT);
        matrix.popPose();
        matrix.pushPose();
        matrix.rotateAround(Axis.XP.rotation((float)Util.getMillis() / 8000.0f), 0.0f, 0.5f, -0.5f);
        matrix.rotateAround(Axis.ZP.rotation((float)Util.getMillis() / 300.0f), 0.5f, 0.5f, 0.0f);
        GeometryBuilder.buildTorusWithGradient(matrix.last().pose(), buffer.getBuffer(NBMRenderType.TRANSLUCENT_QUADS), scale, 0.5f, 0.08f, 0.0f, resolution, gradient);
        matrix.popPose();
    }

    public CircularColorGradient getColorGradient(ItemStack stack) {
        return stack.is(Registry.SUSTAIN) ? LAPIS : WOOL;
    }

    static {
        int alpha = 190;
        float[] point = new float[32];
        for (int i = 0; i < 32; ++i) {
            point[i] = (float)i * (float)Math.PI / 16.0f;
        }
        Color lapis = LAPIS_COLOR = new Color(52, 94, 195, alpha);
        Color lapisBright = new Color(90, 130, 226, alpha);
        Color lapisDark = new Color(18, 64, 139, alpha);
        Color woolWhite = WOOL_COLOR = new Color(254, 254, 254, alpha);
        Color wool = new Color(247, 248, 248, alpha);
        Color woolGray = new Color(232, 235, 235, alpha);
        LAPIS = new CircularColorGradient.Builder().addColor(point[0], lapis).addColor(point[9], lapis).addColor(point[11], lapisBright).addColor(point[13], lapis).addColor(point[18], lapis).addColor(point[20], lapisDark).addColor(point[22], lapis).addColor(point[26], lapis).addColor(point[30], lapisBright).build();
        WOOL = new CircularColorGradient.Builder().addColor(point[30], wool).addColor(point[6], wool).addColor(point[8], woolWhite).addColor(point[11], wool).addColor(point[15], wool).addColor(point[17], woolGray).addColor(point[20], wool).addColor(point[24], wool).addColor(point[27], woolWhite).build();
    }

    public static class Extension
    implements IClientItemExtensions {
        private final BaseItemRender baseItemRender = new SpinningCoreRender();

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return this.baseItemRender;
        }
    }
}

