/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.render.utils;

import java.awt.Color;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.nayrus.noteblockmaster.render.utils.RenderUtils;
import net.nayrus.noteblockmaster.utils.Utils;

public class CircularColorGradient {
    private final NavigableMap<Float, Color> gradientMap;

    public CircularColorGradient(NavigableMap<Float, Color> gradientMap) {
        this.gradientMap = gradientMap;
    }

    public Color getColor(float angle) {
        float range;
        angle = Utils.normalizeAngle(angle);
        Map.Entry<Float, Color> lower = this.gradientMap.floorEntry(Float.valueOf(angle));
        Map.Entry<Float, Color> higher = this.gradientMap.ceilingEntry(Float.valueOf(angle));
        if (lower == null || higher == null) {
            lower = this.gradientMap.lastEntry();
            higher = this.gradientMap.firstEntry();
        }
        float factor = (range = Utils.normalizeAngle(higher.getKey().floatValue() - lower.getKey().floatValue())) == 0.0f ? 0.0f : Utils.normalizeAngle(angle - lower.getKey().floatValue()) / range;
        return RenderUtils.shiftColor(lower.getValue(), higher.getValue(), factor);
    }

    public static class Builder {
        private final NavigableMap<Float, Color> gradientMap = new TreeMap<Float, Color>();

        public Builder addColor(float angle, Color color) {
            angle = Utils.normalizeAngle(angle);
            this.gradientMap.put(Float.valueOf(angle), color);
            return this;
        }

        public CircularColorGradient build() {
            if (this.gradientMap.isEmpty()) {
                throw new IllegalStateException("Gradient must have at least one point");
            }
            return new CircularColorGradient(this.gradientMap);
        }
    }
}

