/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.render.utils;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.util.Mth;
import net.nayrus.noteblockmaster.render.utils.CircularColorGradient;
import org.joml.Matrix4f;

public class GeometryBuilder {
    public static void buildFlippedCone(Matrix4f matrix, VertexConsumer builder, Color color, float scale, float alpha, int resolution) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float startX = 0.0f + (1.0f - scale) / 2.0f;
        float startY = 0.0f + (1.0f - scale) / 2.0f;
        float startZ = -1.0f + (1.0f - scale) / 2.0f;
        float endX = 1.0f - (1.0f - scale) / 2.0f;
        float endY = 1.0f - (1.0f - scale) / 2.0f;
        float endZ = 0.0f - (1.0f - scale) / 2.0f;
        float midX = (startX + endX) / 2.0f;
        float midZ = (startZ + endZ) / 2.0f;
        float dX = Math.abs(midX - startX);
        float dZ = Math.abs(midX - startX);
        for (int i = 0; i < resolution; ++i) {
            float w1 = (float)i / (float)resolution * (float)Math.PI * 2.0f + 0.7853982f;
            float w2 = (float)(i + 1) / (float)resolution * (float)Math.PI * 2.0f + 0.7853982f;
            builder.addVertex(matrix, midX, endY, midZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, midX + dX * Mth.cos((float)w1), endY, midZ + dZ * Mth.sin((float)w1)).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, midX + dX * Mth.cos((float)w2), endY, midZ + dZ * Mth.sin((float)w2)).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, midX, startY, midZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, midX + dX * Mth.cos((float)w1), endY, midZ + dZ * Mth.sin((float)w1)).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, midX + dX * Mth.cos((float)w2), endY, midZ + dZ * Mth.sin((float)w2)).setColor(red, green, blue, alpha);
        }
    }

    public static void buildHalfTorus(Matrix4f matrix, VertexConsumer builder, Color color, float scale, float radius, float innerRadius, float radialOffset, float alpha, int resolution) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float startX = 0.0f + (1.0f - scale) / 2.0f;
        float startY = 0.0f + (1.0f - scale) / 2.0f;
        float startZ = -1.0f + (1.0f - scale) / 2.0f;
        float endX = 1.0f - (1.0f - scale) / 2.0f;
        float endY = 1.0f - (1.0f - scale) / 2.0f;
        float endZ = 0.0f - (1.0f - scale) / 2.0f;
        float midY = (startY + endY) / 2.0f;
        float midX = (startX + endX) / 2.0f;
        float midZ = (startZ + endZ) / 2.0f;
        float r = innerRadius * scale;
        float R = radius * scale;
        for (int i = 0; i < resolution / 2; ++i) {
            float w1 = (float)i / (float)resolution * (float)Math.PI * 2.0f + radialOffset + 0.7853982f;
            float w2 = (float)(i + 1) / (float)resolution * (float)Math.PI * 2.0f + radialOffset + 0.7853982f;
            float cos1 = Mth.cos((float)w1);
            float cos2 = Mth.cos((float)w2);
            float sin1 = Mth.sin((float)w1);
            float sin2 = Mth.sin((float)w2);
            for (int k = 0; k < resolution; ++k) {
                float w3 = (float)k / (float)resolution * (float)Math.PI * 2.0f + 0.7853982f;
                float w4 = (float)(k + 1) / (float)resolution * (float)Math.PI * 2.0f + 0.7853982f;
                float cos3 = Mth.cos((float)w3);
                float cos4 = Mth.cos((float)w4);
                float sin3 = Mth.sin((float)w3);
                float sin4 = Mth.sin((float)w4);
                builder.addVertex(matrix, midX + (R + r * cos3) * cos1, midY + r * sin3, midZ + (R + r * cos3) * sin1).setColor(red, green, blue, alpha);
                builder.addVertex(matrix, midX + (R + r * cos4) * cos1, midY + r * sin4, midZ + (R + r * cos4) * sin1).setColor(red, green, blue, alpha);
                builder.addVertex(matrix, midX + (R + r * cos4) * cos2, midY + r * sin4, midZ + (R + r * cos4) * sin2).setColor(red, green, blue, alpha);
                builder.addVertex(matrix, midX + (R + r * cos3) * cos2, midY + r * sin3, midZ + (R + r * cos3) * sin2).setColor(red, green, blue, alpha);
            }
        }
    }

    public static void buildTorus(Matrix4f matrix, VertexConsumer builder, Color color, float scale, float radius, float innerRadius, float alpha, int resolution) {
        GeometryBuilder.buildTorus(matrix, builder, color, scale, radius, innerRadius, 0.0f, alpha, resolution);
    }

    public static void buildTorus(Matrix4f matrix, VertexConsumer builder, Color color, float scale, float radius, float innerRadius, float radialOffset, float alpha, int resolution) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float startX = 0.0f + (1.0f - scale) / 2.0f;
        float startY = 0.0f + (1.0f - scale) / 2.0f;
        float startZ = -1.0f + (1.0f - scale) / 2.0f;
        float endX = 1.0f - (1.0f - scale) / 2.0f;
        float endY = 1.0f - (1.0f - scale) / 2.0f;
        float endZ = 0.0f - (1.0f - scale) / 2.0f;
        float midY = (startY + endY) / 2.0f;
        float midX = (startX + endX) / 2.0f;
        float midZ = (startZ + endZ) / 2.0f;
        float r = innerRadius * scale;
        float R = radius * scale;
        for (int i = 0; i < resolution; ++i) {
            float w1 = (float)i / (float)resolution * (float)Math.PI * 2.0f + radialOffset + 0.7853982f;
            float w2 = (float)(i + 1) / (float)resolution * (float)Math.PI * 2.0f + radialOffset + 0.7853982f;
            float cos1 = Mth.cos((float)w1);
            float cos2 = Mth.cos((float)w2);
            float sin1 = Mth.sin((float)w1);
            float sin2 = Mth.sin((float)w2);
            for (int k = 0; k < resolution; ++k) {
                float w3 = (float)k / (float)resolution * (float)Math.PI * 2.0f + 0.7853982f;
                float w4 = (float)(k + 1) / (float)resolution * (float)Math.PI * 2.0f + 0.7853982f;
                float cos3 = Mth.cos((float)w3);
                float cos4 = Mth.cos((float)w4);
                float sin3 = Mth.sin((float)w3);
                float sin4 = Mth.sin((float)w4);
                builder.addVertex(matrix, midX + (R + r * cos3) * cos1, midY + r * sin3, midZ + (R + r * cos3) * sin1).setColor(red, green, blue, alpha);
                builder.addVertex(matrix, midX + (R + r * cos4) * cos1, midY + r * sin4, midZ + (R + r * cos4) * sin1).setColor(red, green, blue, alpha);
                builder.addVertex(matrix, midX + (R + r * cos4) * cos2, midY + r * sin4, midZ + (R + r * cos4) * sin2).setColor(red, green, blue, alpha);
                builder.addVertex(matrix, midX + (R + r * cos3) * cos2, midY + r * sin3, midZ + (R + r * cos3) * sin2).setColor(red, green, blue, alpha);
            }
        }
    }

    public static void buildTorusWithGradient(Matrix4f matrix, VertexConsumer builder, float scale, float radius, float innerRadius, float radialOffset, int resolution, CircularColorGradient gradient) {
        float startX = 0.0f + (1.0f - scale) / 2.0f;
        float startY = 0.0f + (1.0f - scale) / 2.0f;
        float startZ = -1.0f + (1.0f - scale) / 2.0f;
        float endX = 1.0f - (1.0f - scale) / 2.0f;
        float endY = 1.0f - (1.0f - scale) / 2.0f;
        float endZ = 0.0f - (1.0f - scale) / 2.0f;
        float midY = (startY + endY) / 2.0f;
        float midX = (startX + endX) / 2.0f;
        float midZ = (startZ + endZ) / 2.0f;
        float r = innerRadius * scale;
        float R = radius * scale;
        for (int i = 0; i < resolution; ++i) {
            float w1 = (float)i / (float)resolution * (float)Math.PI * 2.0f + radialOffset + 0.7853982f;
            float w2 = (float)(i + 1) / (float)resolution * (float)Math.PI * 2.0f + radialOffset + 0.7853982f;
            float cos1 = Mth.cos((float)w1);
            float cos2 = Mth.cos((float)w2);
            float sin1 = Mth.sin((float)w1);
            float sin2 = Mth.sin((float)w2);
            Color lower = gradient.getColor(w1);
            Color higher = gradient.getColor(w2);
            for (int k = 0; k < resolution; ++k) {
                float w3 = (float)k / (float)resolution * (float)Math.PI * 2.0f + 0.7853982f;
                float w4 = (float)(k + 1) / (float)resolution * (float)Math.PI * 2.0f + 0.7853982f;
                float cos3 = Mth.cos((float)w3);
                float cos4 = Mth.cos((float)w4);
                float sin3 = Mth.sin((float)w3);
                float sin4 = Mth.sin((float)w4);
                builder.addVertex(matrix, midX + (R + r * cos3) * cos1, midY + r * sin3, midZ + (R + r * cos3) * sin1).setColor(lower.getRGB());
                builder.addVertex(matrix, midX + (R + r * cos4) * cos1, midY + r * sin4, midZ + (R + r * cos4) * sin1).setColor(lower.getRGB());
                builder.addVertex(matrix, midX + (R + r * cos4) * cos2, midY + r * sin4, midZ + (R + r * cos4) * sin2).setColor(higher.getRGB());
                builder.addVertex(matrix, midX + (R + r * cos3) * cos2, midY + r * sin3, midZ + (R + r * cos3) * sin2).setColor(higher.getRGB());
            }
        }
    }
}

