/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.render.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class RenderUtils {
    public static Vec3 CURRENT_CAM_POS = Vec3.ZERO;

    public static Color shiftColor(Color base, Color target, float factor) {
        if ((factor = Math.min(1.0f, Math.max(-1.0f, factor))) >= 0.0f) {
            return new Color((int)((float)base.getRed() + (float)(target.getRed() - base.getRed()) * factor), (int)((float)base.getGreen() + (float)(target.getGreen() - base.getGreen()) * factor), (int)((float)base.getBlue() + (float)(target.getBlue() - base.getBlue()) * factor), (int)((float)base.getAlpha() + (float)(target.getAlpha() - base.getAlpha()) * factor));
        }
        return new Color((int)((float)base.getRed() - (float)(255 - target.getRed() - base.getRed()) * factor), (int)((float)base.getGreen() - (float)(255 - target.getGreen() - base.getGreen()) * factor), (int)((float)base.getBlue() - (float)(255 - target.getBlue() - base.getBlue()) * factor), (int)((float)base.getAlpha() - (float)(255 - target.getAlpha() - base.getAlpha()) * factor));
    }

    public static Color applyAlpha(Color base, float alpha) {
        alpha = Math.min(1.0f, Math.max(0.0f, alpha));
        return new Color((float)base.getRed() / 255.0f, (float)base.getGreen() / 255.0f, (float)base.getBlue() / 255.0f, alpha);
    }

    public static Vec3 getStableEyeCenter(Camera cam) {
        return cam.isDetached() ? CURRENT_CAM_POS.add(new Vec3(cam.getLookVector()).multiply(Utils.sphereVec(4.0f))) : CURRENT_CAM_POS;
    }

    public static Vec3 getStableEyeCenter() {
        return RenderUtils.getStableEyeCenter(Minecraft.getInstance().gameRenderer.getMainCamera());
    }

    public static Stream<BlockPos> getBlocksInRange(int renderRadius, Predicate<BlockPos> additionalPredicate) {
        Camera cam = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 lookVec = new Vec3(cam.getLookVector());
        Vec3 blockCenter = RenderUtils.getStableEyeCenter(cam);
        return BlockPos.betweenClosedStream((AABB)new AABB(blockCenter.add(Utils.sphereVec(-renderRadius)), blockCenter.add(Utils.sphereVec(renderRadius)))).filter(pos -> RenderUtils.isInRenderRange(pos, blockCenter, lookVec, cam.isDetached(), renderRadius) && additionalPredicate.test((BlockPos)pos));
    }

    public static double distanceVecToBlock(Vec3 vPos, BlockPos pos) {
        return vPos.distanceTo(pos.getCenter());
    }

    public static boolean isInRenderRange(BlockPos pos, Vec3 center, Vec3 look, boolean fullCircle, int renderRadius) {
        return (fullCircle || pos.getCenter().subtract(center).dot(look) >= 0.0) && RenderUtils.distanceVecToBlock(center, pos) <= (double)renderRadius;
    }

    public static void pushAndTranslateRelativeToCam(PoseStack stack) {
        stack.pushPose();
        stack.translate(-CURRENT_CAM_POS.x(), -CURRENT_CAM_POS.y(), -CURRENT_CAM_POS.z());
    }

    public static int getPackedLight(Level level, BlockPos pos) {
        int blockLight = level.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = level.getBrightness(LightLayer.SKY, pos);
        return skyLight << 4 | blockLight;
    }

    public static boolean eventOnRelevantStage(RenderLevelStageEvent e) {
        RenderLevelStageEvent.Stage stage = e.getStage();
        return stage == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || stage == RenderLevelStageEvent.Stage.AFTER_WEATHER;
    }
}

