/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.screen.base.BaseTunerScreen;
import net.nayrus.noteblockmaster.screen.widget.NoteEditBox;
import net.nayrus.noteblockmaster.screen.widget.ValueSlider;
import net.nayrus.noteblockmaster.utils.Utils;

public class NoteTunerScreen
extends BaseTunerScreen
implements Button.OnPress {
    public NoteTunerScreen(ItemStack item) {
        super(item, AdvancedNoteBlock.TOTAL_NOTES);
    }

    protected void init() {
        super.init();
        int ext = this.getExtension();
        this.input = new NoteEditBox(Minecraft.getInstance().font, this.getRelX() + 100 + ext / 2, this.getRelY() + 16, 27, 20, this.maxValue);
        this.addRenderableWidget((GuiEventListener)this.input);
        this.setFocused((GuiEventListener)this.input);
        this.input.setFocused(false);
        this.input.setMaxLength(3);
        this.input.setValue(this.setmode ? Utils.NOTE_STRING[this.value + AdvancedNoteBlock.MIN_NOTE_VAL] : Integer.toString(this.value));
        this.input.setResponder(s -> {
            if (!s.isEmpty()) {
                if (!this.setmode) {
                    int _new;
                    this.value = _new = Integer.parseInt(s);
                    this.slider.setValue((double)_new / (double)this.maxValue);
                } else {
                    try {
                        int _new;
                        this.value = _new = AdvancedNoteBlock.noteStringAsInt(s) - AdvancedNoteBlock.MIN_NOTE_VAL;
                        this.slider.setValue((double)_new / (double)this.maxValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        });
        this.input.setFilter(s -> {
            try {
                if (s.isEmpty()) {
                    return true;
                }
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException e) {
                return Utils.isPartOfNoteString(s) && this.setmode;
            }
        });
        this.add = new Button.Builder((Component)Component.literal((String)"Add"), (Button.OnPress)this).pos(this.getRelX() + 135 + ext / 2, this.getRelY() + 8).size(30, 17).build();
        this.set = new Button.Builder((Component)Component.literal((String)"Set"), (Button.OnPress)this).pos(this.getRelX() + 135 + ext / 2, this.getRelY() + 28).size(30, 17).build();
        this.addRenderableWidget((GuiEventListener)this.add);
        this.addRenderableWidget((GuiEventListener)this.set);
        this.slider = new ValueSlider(this.getRelX() + 10 - ext / 2, this.getRelY() + 16, 80 + ext, 20, (double)this.value / (double)this.maxValue, val -> {
            this.value = (int)(val * (double)AdvancedNoteBlock.TOTAL_NOTES);
            this.input.setValue(this.setmode ? Utils.NOTE_STRING[this.value + AdvancedNoteBlock.MIN_NOTE_VAL] : Integer.toString(this.value));
        });
        this.addRenderableWidget((GuiEventListener)this.slider);
        this.updateButton();
    }

    @Override
    protected void updateButton() {
        super.updateButton();
        this.input.setValue(this.setmode ? Utils.NOTE_STRING[this.value + AdvancedNoteBlock.MIN_NOTE_VAL] : Integer.toString(this.value));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Options op = Minecraft.getInstance().options;
        if ((op.keyUp.matches(keyCode, scanCode) || op.keyDown.matches(keyCode, scanCode) || op.keyRight.matches(keyCode, scanCode) || op.keyLeft.matches(keyCode, scanCode) || op.keyShift.matches(keyCode, scanCode) || op.keyJump.matches(keyCode, scanCode)) && (!Utils.isIntInRange(keyCode, 65, 71) || !this.setmode)) {
            this.onClose();
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.slider.isMouseOver(mouseX, mouseY) || this.input.isMouseOver(mouseX, mouseY)) {
            this.changeValue((int)((double)this.value + scrollY));
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void changeValue(int new_val) {
        this.value = Math.min(Math.max(0, new_val), this.maxValue);
        this.input.setValue(this.setmode ? Utils.NOTE_STRING[this.value + AdvancedNoteBlock.MIN_NOTE_VAL] : Integer.toString(this.value));
        this.slider.setValue((double)this.value / (double)this.maxValue);
    }
}

