/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.datagen;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.nayrus.noteblockmaster.sound.SoundRegistry;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public class NBMSoundProvider
extends SoundDefinitionsProvider {
    protected NBMSoundProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "noteblockmaster", helper);
    }

    public void registerSounds() {
        this.add(SoundRegistry.SMITHING, SoundDefinition.definition().with(NBMSoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block/smithing_table/smithing_table2"))).subtitle("sounds.noteblockmaster.noteblock_upgrade"));
        this.addBasicLocalSounds(SoundRegistry.SUSTAINED_HARP_SOUND.getA(), "sustained_harp");
        this.addBasicLocalSounds(SoundRegistry.SUSTAINED_BASS_SOUND.getA(), "sustained_bass");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_BASEDRUM_SOUND, "sustained_basedrum");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_BANJO_SOUND, "sustained_banjo");
        this.addBasicLocalSounds(SoundRegistry.SUSTAINED_FLUTE_SOUND.getA(), "sustained_flute");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_SNARE_SOUND, "sustained_snare");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_HAT_SOUND, "sustained_hat");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_CHIME_SOUND, "sustained_chime");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_COW_BELL_SOUND, "sustained_cowbell");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_BIT_SOUND, "sustained_bit");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_PLING_SOUND, "sustained_pling");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_XYLOPHONE_SOUND, "sustained_xylophone");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_IRON_XYLOPHONE_SOUND, "sustained_ironxylophone");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_GUITAR_SOUND, "sustained_guitar");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_DIDGERIDOO_SOUND, "sustained_didgeridoo");
        this.addBasicLocalSound(SoundRegistry.SUSTAINED_BELL_SOUND, "sustained_bell");
    }

    private void addBasicLocalSound(Supplier<SoundEvent> sustainedSound, String name) {
        this.add(sustainedSound, SoundDefinition.definition().with(NBMSoundProvider.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)name))).subtitle("sounds.noteblockmaster.".concat(name)));
    }

    private void addBasicLocalSounds(List<Supplier<SoundEvent>> soundList, String name) {
        for (int i = 0; i < soundList.size(); ++i) {
            this.addBasicLocalSound(soundList.get(i), name + (i + 1));
        }
    }
}

