/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.command.BPMInfoCommand;
import net.nayrus.noteblockmaster.command.MainCommand;
import net.nayrus.noteblockmaster.event.AdvancedNoteBlockEvent;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.network.payload.ConfigCheck;
import net.nayrus.noteblockmaster.network.payload.RemoveBlockInfo;
import net.nayrus.noteblockmaster.network.payload.SyncBlockInfos;
import net.nayrus.noteblockmaster.render.ANBInfoRender;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.sound.SoundRegistry;
import net.nayrus.noteblockmaster.utils.FinalTuple;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.command.ConfigCommand;

public class CommonEvents {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        new BPMInfoCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        MainCommand.mainCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new ConfigCheck((byte)AdvancedNoteBlock.MIN_NOTE_VAL, (byte)AdvancedNoteBlock.MAX_NOTE_VAL, (byte)AdvancedNoteBlock.SUBTICK_LENGTH), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (ANBInfoRender.NOTE_OFF_SYNC || ANBInfoRender.SUBTICK_OFF_SYNC) {
            AdvancedNoteBlock.loadPropertiesFromConfig(null);
        }
    }

    @SubscribeEvent
    public static void onANBStateChange(AdvancedNoteBlockEvent.StateChange e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (e instanceof AdvancedNoteBlockEvent.Removed) {
            PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new RemoveBlockInfo(e.getPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        HashMap<BlockPos, ANBInfoRender.BlockInfo> toSync = new HashMap<BlockPos, ANBInfoRender.BlockInfo>();
        toSync.put(e.getPos(), new ANBInfoRender.BlockInfo(AdvancedNoteBlock.getNoteValue(e.getState()), (Integer)e.getState().getValue((Property)AdvancedNoteBlock.SUBTICK)));
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SyncBlockInfos(toSync), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void useItemOnBlockEvent(UseItemOnBlockEvent event) {
        UseOnContext context = event.getUseOnContext();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player instanceof Player) {
            Inventory inv;
            Player player2 = player;
            BlockPos pos = context.getClickedPos();
            BlockState state = level.getBlockState(pos);
            FinalTuple.ItemStackTuple items = FinalTuple.getHeldItems(player2);
            if (items.contains(TunerItem.class) && state.getBlock() instanceof NoteBlock && (inv = player2.getInventory()).countItem(Items.GOLD_NUGGET) >= 3) {
                if (!level.isClientSide) {
                    level.setBlock(pos, (BlockState)((Block)Registry.ADVANCED_NOTEBLOCK.get()).defaultBlockState().setValue((Property)AdvancedNoteBlock.NOTE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)NoteBlock.NOTE) + AdvancedNoteBlock.DEFAULT_NOTE)), 3);
                    level.playSound(null, pos, SoundRegistry.SMITHING.get(), SoundSource.BLOCKS, 0.5f, NoteBlock.getPitchFromNote((int)14) + RandomSource.create().nextFloat() / 10.0f);
                    if (!player2.isCreative()) {
                        Utils.removeItemsFromInventory(inv, Items.GOLD_NUGGET, 3);
                    }
                } else {
                    level.addDestroyBlockEffect(pos, Blocks.GOLD_BLOCK.defaultBlockState());
                }
                if (((ItemStack)items.getA()).getItem() instanceof TunerItem) {
                    event.cancelWithResult(ItemInteractionResult.SUCCESS);
                } else {
                    player2.swing(InteractionHand.OFF_HAND);
                    event.cancelWithResult(ItemInteractionResult.CONSUME);
                }
            }
            if (state.getBlock() instanceof RepeaterBlock && items.contains((Item)Registry.COMPOSER.get())) {
                ItemStack composer = items.getFirst((Item)Registry.COMPOSER.get());
                ComposeData cData = ComposeData.getComposeData(composer);
                int target = cData.postDelay();
                int set = Math.min(target, 4);
                if (target > 0) {
                    target -= set;
                    if (!level.isClientSide()) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)RepeaterBlock.DELAY, (Comparable)Integer.valueOf(set)), 3);
                        composer.set(Registry.COMPOSE_DATA, (Object)new ComposeData(cData.beat(), cData.subtick(), target, cData.bpm()));
                    }
                    if (((ItemStack)items.getA()).is(Registry.COMPOSER)) {
                        event.cancelWithResult(ItemInteractionResult.SUCCESS);
                    } else {
                        event.cancelWithResult(ItemInteractionResult.CONSUME);
                        player2.swing(InteractionHand.OFF_HAND);
                    }
                } else {
                    event.cancelWithResult(ItemInteractionResult.FAIL);
                    if (level.isClientSide()) {
                        Utils.playFailUse(level, player2, pos);
                    }
                }
            }
        }
    }
}

