/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.network.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record TunerData(int value, byte flags) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TunerData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"tunerdata"));
    public static final Codec<TunerData> TUNER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("value").forGetter(TunerData::value), (App)Codec.BYTE.fieldOf("setmode").forGetter(TunerData::flags)).apply((Applicative)instance, TunerData::new));
    public static final StreamCodec<FriendlyByteBuf, TunerData> TUNER_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, TunerData::value, (StreamCodec)ByteBufCodecs.BYTE, TunerData::flags, TunerData::new);

    public CustomPacketPayload.Type<TunerData> type() {
        return TYPE;
    }

    public static TunerData of(int value, boolean setmode, boolean offhand) {
        byte flags = 0;
        if (setmode) {
            flags = (byte)(flags | 1);
        }
        if (offhand) {
            flags = (byte)(flags | 2);
        }
        return new TunerData(value, flags);
    }

    public boolean isSetmode() {
        return (this.flags() & 1) != 0;
    }

    public boolean isInOffhand() {
        return (this.flags() & 2) != 0;
    }
}

