/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.screen.base.BaseTunerScreen;
import net.nayrus.noteblockmaster.screen.widget.IntegerEditBox;
import net.nayrus.noteblockmaster.screen.widget.ValueSlider;
import net.nayrus.noteblockmaster.setup.Registry;

public class TempoTunerScreen
extends BaseTunerScreen
implements Button.OnPress {
    private boolean disableButtons;

    public TempoTunerScreen(ItemStack item, ItemStack composer, boolean offhand) {
        super(item, AdvancedNoteBlock.SUBTICKS, offhand);
        if (!composer.is(Registry.COMPOSER)) {
            return;
        }
        this.setmode = true;
        this.value = ComposeData.getComposeData(composer).subtick();
        this.disableButtons = true;
    }

    protected void init() {
        super.init();
        this.input = new IntegerEditBox(this.font, this.getRelX() + 100, this.getRelY() + 16, 27, 20, this.maxValue, true);
        this.addRenderableWidget((GuiEventListener)this.input);
        this.setFocused((GuiEventListener)this.input);
        this.input.setEditable(!this.disableButtons);
        this.input.setFocused(false);
        this.input.setMaxLength(3);
        this.input.setValue(Integer.toString(this.value));
        this.input.setResponder(s -> {
            if (!s.isEmpty()) {
                int _new;
                this.value = _new = Integer.parseInt(s);
                this.slider.setValue((double)_new / ((double)this.maxValue - 1.0));
            }
        });
        this.add = new Button.Builder((Component)Component.literal((String)"Add"), (Button.OnPress)this).pos(this.getRelX() + 135, this.getRelY() + 8).size(30, 17).build();
        this.set = new Button.Builder((Component)Component.literal((String)"Set"), (Button.OnPress)this).pos(this.getRelX() + 135, this.getRelY() + 28).size(30, 17).build();
        this.updateButton();
        this.addRenderableWidget((GuiEventListener)this.add);
        this.addRenderableWidget((GuiEventListener)this.set);
        this.slider = new ValueSlider(this.getRelX() + 10, this.getRelY() + 16, 80, 20, (double)this.value / ((double)this.maxValue - 1.0), val -> {
            this.value = (int)(val * (double)(this.maxValue - 1));
            this.input.setValue(Integer.toString(this.value));
        });
        this.slider.active = !this.disableButtons;
        this.addRenderableWidget((GuiEventListener)this.slider);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Options op = Minecraft.getInstance().options;
        if (op.keyUp.matches(keyCode, scanCode) || op.keyDown.matches(keyCode, scanCode) || op.keyRight.matches(keyCode, scanCode) || op.keyLeft.matches(keyCode, scanCode) || op.keyJump.matches(keyCode, scanCode)) {
            this.onClose();
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void onPress(Button button) {
        if (!this.disableButtons) {
            super.onPress(button);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.slider.isMouseOver(mouseX, mouseY) || this.input.isMouseOver(mouseX, mouseY)) {
            this.changeValue((int)((double)this.value + scrollY * (double)this.getScrollFactor(false).floatValue()));
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void changeValue(int new_val) {
        this.value = Math.min(Math.max(0, new_val), this.maxValue - 1);
        this.input.setValue(Integer.toString(this.value));
        this.slider.setValue((double)this.value / ((double)this.maxValue - 1.0));
    }
}

