/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.screen.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.nayrus.noteblockmaster.item.ComposersNote;
import net.nayrus.noteblockmaster.network.data.ComposeData;
import net.nayrus.noteblockmaster.screen.base.BaseScreen;
import net.nayrus.noteblockmaster.screen.widget.FloatEditBox;
import net.nayrus.noteblockmaster.screen.widget.IntegerEditBox;
import net.nayrus.noteblockmaster.setup.Registry;
import net.neoforged.neoforge.network.PacketDistributor;

public class BaseComposerScreen
extends BaseScreen
implements Button.OnPress {
    protected IntegerEditBox beat;
    protected FloatEditBox bpm;
    protected Button decrease;
    protected final ItemStack composer;
    public float bpm_val;
    public int beat_val;
    private final float init_bpm;
    private final int init_beat;

    protected BaseComposerScreen(ItemStack composer) {
        super(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"textures/gui/tunerscreen.png"), 176, 53);
        this.composer = composer;
        ComposeData data = ComposeData.getComposeData(composer);
        this.init_bpm = data.bpm();
        this.bpm_val = data.bpm();
        this.init_beat = data.beat();
        this.beat_val = data.beat();
    }

    public void onPress(Button button) {
        if (button.equals(this.decrease)) {
            this.changeBeatVal(this.beat_val - 1);
        }
    }

    public void onClose() {
        if (this.init_bpm != this.bpm_val || this.init_beat != this.beat_val) {
            Tuple<Integer, Integer> calc = ComposersNote.subtickAndPauseOnBeat(this.beat_val, this.bpm_val);
            ComposeData _new = new ComposeData(this.beat_val, (Integer)calc.getA(), (Integer)calc.getB(), this.bpm_val);
            this.composer.set(Registry.COMPOSE_DATA, (Object)_new);
            PacketDistributor.sendToServer((CustomPacketPayload)_new, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        super.onClose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.bpm.isMouseOver(mouseX, mouseY)) {
            this.changeBPMVal(BigDecimal.valueOf(this.bpm_val).add(this.getScrollFactor().multiply(BigDecimal.valueOf(scrollY))).setScale(4, RoundingMode.HALF_UP).floatValue());
        }
        if (this.beat.isMouseOver(mouseX, mouseY)) {
            this.changeBeatVal((int)((double)this.beat_val + scrollY * (double)this.getScrollFactor().floatValue()));
        } else if (this.decrease.isMouseOver(mouseX, mouseY)) {
            this.changeBeatVal((int)((double)this.beat_val + scrollY * (double)this.getScrollFactor().floatValue()));
            this.decrease.playDownSound(Minecraft.getInstance().getSoundManager());
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void changeBeatVal(int new_val) {
        this.beat_val = Math.min(Math.max(0, new_val), this.beat.getMaxVal());
        this.beat.setValue(Integer.toString(this.beat_val));
    }

    public void changeBPMVal(float new_val) {
        this.bpm_val = Math.min(Math.max(0.0f, new_val), this.bpm.getMaxVal());
        this.bpm.setValue(Float.toString(this.bpm_val));
    }
}

