/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.setup.config;

import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.neoforge.common.ModConfigSpec;

public class StartupConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.ConfigValue<Object> LOWER_NOTE_LIMIT = BUILDER.comment(" Lowest key possible.\n Range: \"C1\", \"C#1\", ..., \"F#3\" or 0 ~ 30").define("minNote", (Object)"C3", obj -> StartupConfig.isNoteValue(obj, false));
    public static final ModConfigSpec.ConfigValue<Object> HIGHER_NOTE_LIMIT = BUILDER.comment(" Highest key possible.\n Range: \"F#5\", \"G5\", ..., \"A#7\" or 54 ~ 82").define("maxNote", (Object)"C6", obj -> StartupConfig.isNoteValue(obj, true));
    public static final ModConfigSpec.IntValue SUBTICK_LENGTH = BUILDER.comment(" Time in ms per subtick. Amount of subticks equals 2 ticks (100ms) / subtick length").defineInRange("subtickDelay", 5, 5, 25);
    public static final ModConfigSpec START_UP = BUILDER.build();
    public static boolean UPDATED = false;

    public static boolean isNoteValue(Object str, boolean high) {
        if (!(str instanceof String)) {
            if (str instanceof Integer) {
                Integer val = (Integer)str;
                return Utils.isIntInRange(val, high ? 54 : 0, high ? 82 : 30);
            }
            return false;
        }
        String configStr = (String)str;
        try {
            return high ? AdvancedNoteBlock.noteStringAsInt(configStr, false) >= 54 : AdvancedNoteBlock.noteStringAsInt(configStr, false) <= 30;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void updateStartUpAndSave() {
        LOWER_NOTE_LIMIT.set((Object)AdvancedNoteBlock.MIN_NOTE_VAL);
        HIGHER_NOTE_LIMIT.set((Object)AdvancedNoteBlock.MAX_NOTE_VAL);
        SUBTICK_LENGTH.set((Object)AdvancedNoteBlock.SUBTICK_LENGTH);
        START_UP.save();
        UPDATED = true;
    }
}

