/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.sound;

import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.block.TuningCore;
import net.nayrus.noteblockmaster.network.NetworkUtil;
import net.nayrus.noteblockmaster.network.payload.ScheduleCoreSound;
import net.nayrus.noteblockmaster.sound.AdvancedInstrument;
import net.nayrus.noteblockmaster.sound.CoreSound;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SubTickScheduler {
    public static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new SubtickThread());
    public static final HashMap<BlockPos, CoreSound> SUSTAINED_SOUNDS = new HashMap();
    public static final RandomSource RANDOM = RandomSource.create();

    public static void delayedNoteBlockEvent(BlockState state, Level level, BlockPos pos, AdvancedInstrument instrument, float volume) {
        executor.schedule(() -> {
            int i = AdvancedNoteBlock.getNoteValue(state);
            level.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, (double)(((float)i - 2.0f) / 29.0f), 0.0, 0.0);
            level.playSound(null, pos, (SoundEvent)instrument.getSoundEvent().value(), SoundSource.RECORDS, volume, AdvancedNoteBlock.getPitchFromNote(i));
        }, (long)((Integer)state.getValue((Property)AdvancedNoteBlock.SUBTICK)).intValue() * (long)AdvancedNoteBlock.SUBTICK_LENGTH, TimeUnit.MILLISECONDS);
    }

    public static void delayedCoredNoteBlockEvent(BlockState anb, BlockState core, Level level, BlockPos pos, AdvancedInstrument instrument) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        NetworkUtil.broadcastCoreSound(serverLevel, ScheduleCoreSound.of(pos, TuningCore.getSustain(core), AdvancedNoteBlock.getNoteValue(anb), (float)TuningCore.getVolume(core) / 20.0f, instrument, TuningCore.isMixing(core), (Integer)anb.getValue((Property)AdvancedNoteBlock.SUBTICK)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void delayedCoredNoteBlockEvent(BlockPos pos, int sustainIndex, int noteVal, float volume, AdvancedInstrument instrument, boolean noDecay, int delay) {
        CoreSound instance = new CoreSound(instrument.getSustainedEvent(sustainIndex), SoundSource.RECORDS, volume, noteVal, RandomSource.create((long)RANDOM.nextLong()), pos, instrument.getSustainTime(sustainIndex), noDecay);
        executor.schedule(() -> Minecraft.getInstance().execute(() -> SubTickScheduler.playSustainingSound(instance)), (long)delay * (long)AdvancedNoteBlock.SUBTICK_LENGTH, TimeUnit.MILLISECONDS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSustainingSound(CoreSound sound) {
        SubTickScheduler.playbackStop(sound.getImmutablePos());
        Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playbackStop(BlockPos pos) {
        SUSTAINED_SOUNDS.computeIfPresent(pos.immutable(), (p, sound) -> {
            if (!sound.getChannel().stopped()) {
                Minecraft.getInstance().getSoundManager().stop((SoundInstance)sound);
            }
            if (sound.getParticle() != null && sound.getParticle().isAlive()) {
                sound.getParticle().remove();
            }
            return null;
        });
    }

    static class SubtickThread
    implements ThreadFactory {
        SubtickThread() {
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("NBM Subtick Thread");
            return thread;
        }
    }
}

