/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.utils;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FinalTuple<A, B> {
    private final A a;
    private final B b;

    public FinalTuple(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public A getA() {
        return this.a;
    }

    public B getB() {
        return this.b;
    }

    public static ItemStackTuple getHeldItems(Player player) {
        return new ItemStackTuple(player.getMainHandItem(), player.getOffhandItem());
    }

    public static class ItemStackTuple
    extends FinalTuple<ItemStack, ItemStack> {
        public ItemStackTuple(ItemStack a, ItemStack b) {
            super(a, b);
        }

        public boolean contains(Item item) {
            return ((ItemStack)this.getA()).is(item) || ((ItemStack)this.getB()).is(item);
        }

        @SafeVarargs
        public final boolean contains(Class<? extends Item> ... itemclasses) {
            for (Class<? extends Item> itemclass : itemclasses) {
                if (!itemclass.isInstance(((ItemStack)this.getA()).getItem()) && !itemclass.isInstance(((ItemStack)this.getB()).getItem())) continue;
                return true;
            }
            return false;
        }

        public final boolean contains(Item ... items) {
            for (Item i : items) {
                if (!((ItemStack)this.getA()).is(i) && !((ItemStack)this.getB()).is(i)) continue;
                return true;
            }
            return false;
        }

        public ItemStack getFirst(Item item) {
            if (((ItemStack)this.getA()).is(item)) {
                return (ItemStack)this.getA();
            }
            if (((ItemStack)this.getB()).is(item)) {
                return (ItemStack)this.getB();
            }
            return ItemStack.EMPTY;
        }

        public ItemStack getFirst(Class<? extends Item> itemclass) {
            if (itemclass.isInstance(((ItemStack)this.getA()).getItem())) {
                return (ItemStack)this.getA();
            }
            if (itemclass.isInstance(((ItemStack)this.getB()).getItem())) {
                return (ItemStack)this.getB();
            }
            return ItemStack.EMPTY;
        }
    }
}

