/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.utils;

import java.awt.Color;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class Utils {
    public static final String[] NOTE_STRING = new String[]{"C1", "C\u266f1", "D1", "D\u266f1", "E1", "F1", "F\u266f1", "G1", "G\u266f1", "A1", "A\u266f1", "B1", "C2", "C\u266f2", "D2", "D\u266f2", "E2", "F2", "F\u266f2", "G2", "G\u266f2", "A2", "A\u266f2", "B2", "C3", "C\u266f3", "D3", "D\u266f3", "E3", "F3", "F\u266f3", "G3", "G\u266f3", "A3", "A\u266f3", "B3", "C4", "C\u266f4", "D4", "D\u266f4", "E4", "F4", "F\u266f4", "G4", "G\u266f4", "A4", "A\u266f4", "B4", "C5", "C\u266f5", "D5", "D\u266f5", "E5", "F5", "F\u266f5", "G5", "G\u266f5", "A5", "A\u266f5", "B5", "C6", "C\u266f6", "D6", "D\u266f6", "E6", "F6", "F\u266f6", "G6", "G\u266f6", "A6", "A\u266f6", "B6", "C7", "C\u266f7", "D7", "D\u266f7", "E7", "F7", "F\u266f7", "G7", "G\u266f7", "A7", "A\u266f7", "B7"};
    public static final float PI = (float)Math.PI;

    public static boolean isPartOfNoteString(String s) {
        String t = s.replace('#', '\u266f').toUpperCase();
        return Arrays.stream(NOTE_STRING).anyMatch(r -> r.contains(t));
    }

    public static boolean isIntInRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static Vec3 sphereVec(float radius) {
        return new Vec3((double)radius, (double)radius, (double)radius);
    }

    public static void sendDesyncWarning(Player player) {
        player.sendSystemMessage((Component)Component.translatable((String)"text.config.desync_info").withColor(Color.GREEN.getRGB()).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/nbm saveconfig")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"text.config.sync_save_hovertext").withColor(Color.LIGHT_GRAY.getRGB())))));
    }

    public static void removeItemsFromInventory(Inventory inv, Item item, int amount) {
        ItemStack itemstack;
        if (amount <= 0) {
            return;
        }
        int removed = 0;
        for (int i = inv.getContainerSize() - 1; !(i < 0 || (itemstack = inv.getItem(i)).getItem().equals(item) && (removed += inv.removeItem(i, amount - removed).getCount()) == amount); --i) {
        }
    }

    public static void playFailUse(Level level, Player player, BlockPos pos) {
        level.playSound(player, pos, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, 0.8f);
    }

    public static float exponentialFloor(float start, float max, float current, float power) {
        return Math.max(0.05f, start - (float)(Math.pow(current, power) * (double)start / Math.pow(max, power)));
    }

    public static float getRotationToX(Vec3 vec) {
        Vec3 vecXZ = vec.subtract(0.0, vec.y(), 0.0).normalize();
        double dotX = vecXZ.dot(new Vec3(1.0, 0.0, 0.0));
        double dotZ = vecXZ.dot(new Vec3(0.0, 0.0, 1.0));
        return (float)(Math.acos(dotX) * (double)(dotZ < 0.0 ? -1 : 1));
    }

    public static void scheduleTick(ServerLevel level, BlockPos pos, Block block, int delay) {
        if (!level.getBlockTicks().hasScheduledTick(pos, (Object)block)) {
            level.scheduleTick(pos, block, delay);
        }
    }

    public static InteractionResult swingHelper(Player player, InteractionHand hand, boolean client) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionResult.SUCCESS;
        }
        if (client) {
            player.swing(hand);
        }
        return InteractionResult.CONSUME;
    }

    public static float normalizeAngle(float angle) {
        return (angle % ((float)Math.PI * 2) + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public static enum PROPERTY {
        NOTE,
        TEMPO;

    }
}

