/*
 * Decompiled with CFR 0.152.
 */
package com.flubel.blockify;

import com.flubel.blockify.metrics.Metrics;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Blockify
extends JavaPlugin
implements Listener {
    private final Map<Chunk, Map<Material, Integer>> blockCounts = new HashMap<Chunk, Map<Material, Integer>>();
    private Map<Material, Integer> blockLimits = new HashMap<Material, Integer>();
    private Map<EntityType, Integer> entityLimits = new HashMap<EntityType, Integer>();
    private final Gson gson = new Gson();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadLimits();
        this.loadEntityLimits();
        this.getCommand("blockify").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        int pluginId = 27240;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        this.getLogger().info("\u001b[38;2;23;138;214m====================================================================\u001b[0m");
        this.getLogger().info(" \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2557      \u2588\u2588\u2588\u2588\u2588\u2588\u2557  \u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2557  \u2588\u2588\u2557\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2557   \u2588\u2588\u2557\u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2551     \u2588\u2588\u2554\u2550\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u2588\u2588\u2551 \u2588\u2588\u2554\u255d\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u255a\u2588\u2588\u2557 \u2588\u2588\u2554\u255d\u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2551     \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2551     \u2588\u2588\u2588\u2588\u2588\u2554\u255d \u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2557   \u255a\u2588\u2588\u2588\u2588\u2554\u255d \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2551     \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2551     \u2588\u2588\u2554\u2550\u2588\u2588\u2557 \u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u255d    \u255a\u2588\u2588\u2554\u255d  \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2551  \u2588\u2588\u2557\u2588\u2588\u2551\u2588\u2588\u2551        \u2588\u2588\u2551   \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u255a\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u2550\u2550\u2550\u2550\u255d  \u255a\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u255d\u255a\u2550\u255d        \u255a\u2550\u255d   \u001b[0m");
        this.getLogger().info(" \u001b[0m");
        this.getLogger().info("\u001b[38;2;225;215;0m                           Version: 1.0.0                           \u001b[0m");
        this.getLogger().info("\u001b[38;2;0;255;0m                           Plugin Started                           \u001b[0m");
        this.getLogger().info(" \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m                          (Made by Flubel)                          \u001b[0m");
        this.getLogger().info(" \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m====================================================================\u001b[0m");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            JsonObject pluginData = this.fetchVersion("JByomf7ouwBQAJWE8KNJ");
            if (pluginData != null) {
                String latestVersion;
                String currentVersion = this.getDescription().getVersion();
                if (this.isNewerVersion(currentVersion, latestVersion = pluginData.get("version").getAsString())) {
                    Bukkit.getLogger().info("[Blockify] Update available: " + latestVersion);
                    Bukkit.getLogger().info("[Blockify] Changelog: " + pluginData.get("changelog").getAsString());
                } else {
                    Bukkit.getLogger().info("[Blockify] Plugin Running at latest Version");
                }
            }
        });
    }

    private boolean isNewerVersion(String current, String latest) {
        String[] cParts = current.split("\\.");
        String[] lParts = latest.split("\\.");
        int length = Math.max(cParts.length, lParts.length);
        for (int i = 0; i < length; ++i) {
            int l;
            int c = i < cParts.length ? Integer.parseInt(cParts[i]) : 0;
            int n = l = i < lParts.length ? Integer.parseInt(lParts[i]) : 0;
            if (l > c) {
                return true;
            }
            if (l >= c) continue;
            return false;
        }
        return false;
    }

    public void onDisable() {
        this.blockCounts.clear();
        this.getLogger().info("\u001b[38;2;23;138;214m====================================================================\u001b[0m");
        this.getLogger().info(" \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2557      \u2588\u2588\u2588\u2588\u2588\u2588\u2557  \u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2557  \u2588\u2588\u2557\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2557   \u2588\u2588\u2557\u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2551     \u2588\u2588\u2554\u2550\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u2588\u2588\u2551 \u2588\u2588\u2554\u255d\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u255a\u2588\u2588\u2557 \u2588\u2588\u2554\u255d\u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2551     \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2551     \u2588\u2588\u2588\u2588\u2588\u2554\u255d \u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2557   \u255a\u2588\u2588\u2588\u2588\u2554\u255d \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2551     \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2551     \u2588\u2588\u2554\u2550\u2588\u2588\u2557 \u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u255d    \u255a\u2588\u2588\u2554\u255d  \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2551  \u2588\u2588\u2557\u2588\u2588\u2551\u2588\u2588\u2551        \u2588\u2588\u2551   \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m   \u255a\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u2550\u2550\u2550\u2550\u255d  \u255a\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u255d\u255a\u2550\u255d        \u255a\u2550\u255d   \u001b[0m");
        this.getLogger().info(" \u001b[0m");
        this.getLogger().info("\u001b[38;2;225;215;0m                           Version: 1.0.0                           \u001b[0m");
        this.getLogger().info("\u001b[38;2;255;0;0m                           Plugin Stopped                           \u001b[0m");
        this.getLogger().info(" \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m                          (Made by Flubel)                          \u001b[0m");
        this.getLogger().info(" \u001b[0m");
        this.getLogger().info("\u001b[38;2;23;138;214m====================================================================\u001b[0m");
    }

    private void loadLimits() {
        this.blockLimits.clear();
        for (String key : this.getConfig().getConfigurationSection("limits").getKeys(false)) {
            try {
                Material mat = Material.valueOf((String)key.toUpperCase());
                int limit = this.getConfig().getInt("limits." + key);
                this.blockLimits.put(mat, limit);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid material in config: " + key);
            }
        }
    }

    private void loadEntityLimits() {
        this.entityLimits.clear();
        if (this.getConfig().isConfigurationSection("entity-limits")) {
            for (String key : this.getConfig().getConfigurationSection("entity-limits").getKeys(false)) {
                try {
                    EntityType type = EntityType.valueOf((String)key.toUpperCase());
                    int limit = this.getConfig().getInt("entity-limits." + key);
                    this.entityLimits.put(type, limit);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid entity type in config: " + key);
                }
            }
        }
    }

    public boolean onCommand(CommandSender player, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission("blockify.admin")) {
                player.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "| " + ChatColor.RED + "You don't have permission to use this command");
                return true;
            }
            this.reloadConfig();
            this.loadLimits();
            this.loadEntityLimits();
            player.sendMessage(ChatColor.GREEN + "" + ChatColor.BOLD + "| " + ChatColor.GREEN + "Config reloaded!");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("update")) {
            if (player.hasPermission("blockify.admin")) {
                JsonObject pluginData = this.fetchVersion("JByomf7ouwBQAJWE8KNJ");
                if (pluginData != null) {
                    String latestVersion;
                    String currentVersion = this.getDescription().getVersion();
                    if (this.isNewerVersion(currentVersion, latestVersion = pluginData.get("version").getAsString())) {
                        player.sendMessage(ChatColor.AQUA + "" + ChatColor.BOLD + "------------------- " + ChatColor.GOLD + "" + ChatColor.BOLD + "Blockify" + ChatColor.AQUA + "" + ChatColor.BOLD + " -------------------");
                        player.sendMessage(" ");
                        player.sendMessage(ChatColor.BLUE + "A new Version is Available.");
                        player.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "Current: " + ChatColor.RED + currentVersion + ChatColor.AQUA + " | " + ChatColor.GREEN + "" + ChatColor.BOLD + "Latest: " + ChatColor.GREEN + latestVersion);
                        player.sendMessage(ChatColor.GREEN + "" + ChatColor.BOLD + "[Download] " + ChatColor.RESET + ChatColor.UNDERLINE + "https://modrinth.com/plugin/flubel-blockify");
                        player.sendMessage(" ");
                        player.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "Changelog: " + ChatColor.GOLD + pluginData.get("changelog").getAsString());
                        player.sendMessage(" ");
                        player.sendMessage(ChatColor.AQUA + "" + ChatColor.BOLD + "--------------------------------------------");
                    } else {
                        player.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "| " + ChatColor.GOLD + "Plugin is at the latest version");
                    }
                }
            } else {
                player.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "| " + ChatColor.RED + "You don't have permission to use this command");
            }
        }
        return false;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        Material type = block.getType();
        if (!this.blockLimits.containsKey(type)) {
            return;
        }
        int max = this.blockLimits.get(type);
        Chunk chunk = block.getChunk();
        Map counts = this.blockCounts.computeIfAbsent(chunk, c -> new HashMap());
        int count = counts.getOrDefault(type, 0);
        if (count >= max) {
            event.setCancelled(true);
            return;
        }
        counts.put(type, count + 1);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        String latestVersion;
        String currentVersion;
        JsonObject pluginData;
        Player player = event.getPlayer();
        if ((player.hasPermission("blockify.admin") || player.isOp()) && (pluginData = this.fetchVersion("JByomf7ouwBQAJWE8KNJ")) != null && this.isNewerVersion(currentVersion = this.getDescription().getVersion(), latestVersion = pluginData.get("version").getAsString())) {
            player.sendMessage(ChatColor.AQUA + "" + ChatColor.BOLD + "------------------- " + ChatColor.GOLD + "" + ChatColor.BOLD + "Blockify" + ChatColor.AQUA + "" + ChatColor.BOLD + " -------------------");
            player.sendMessage(" ");
            player.sendMessage(ChatColor.BLUE + "A new Version is Available.");
            player.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "Current: " + ChatColor.RED + currentVersion + ChatColor.AQUA + " | " + ChatColor.GREEN + "" + ChatColor.BOLD + "Latest: " + ChatColor.GREEN + latestVersion);
            player.sendMessage(ChatColor.GREEN + "" + ChatColor.BOLD + "[Download] " + ChatColor.RESET + ChatColor.UNDERLINE + "https://modrinth.com/plugin/flubel-blockify");
            player.sendMessage(" ");
            player.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "Changelog: " + ChatColor.GOLD + pluginData.get("changelog").getAsString());
            player.sendMessage(" ");
            player.sendMessage(ChatColor.AQUA + "" + ChatColor.BOLD + "--------------------------------------------");
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        int count;
        Block block = event.getBlock();
        Material type = block.getType();
        if (!this.blockLimits.containsKey(type)) {
            return;
        }
        Chunk chunk = block.getChunk();
        Map<Material, Integer> counts = this.blockCounts.get(chunk);
        if (counts != null && (count = counts.getOrDefault(type, 0).intValue()) > 0) {
            counts.put(type, count - 1);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        HashMap<Material, Integer> counts = new HashMap<Material, Integer>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < chunk.getWorld().getMaxHeight(); ++y) {
                for (int z = 0; z < 16; ++z) {
                    Block block = chunk.getBlock(x, y, z);
                    Material type = block.getType();
                    if (!this.blockLimits.containsKey(type)) continue;
                    counts.put(type, counts.getOrDefault(type, 0) + 1);
                }
            }
        }
        this.blockCounts.put(chunk, counts);
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        long count;
        Entity entity = event.getEntity();
        EntityType type = entity.getType();
        if (!this.entityLimits.containsKey(type)) {
            return;
        }
        int max = this.entityLimits.get(type);
        Chunk chunk = entity.getLocation().getChunk();
        long l = count = chunk.getEntities().length > 0 ? Arrays.stream(chunk.getEntities()).filter(e -> e.getType() == type).count() : 0L;
        if (count >= (long)max) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehiclePlace(VehicleCreateEvent event) {
        Vehicle entity = event.getVehicle();
        EntityType type = entity.getType();
        if (!this.entityLimits.containsKey(type)) {
            return;
        }
        int max = this.entityLimits.get(type);
        Chunk chunk = entity.getLocation().getChunk();
        long count = Arrays.stream(chunk.getEntities()).filter(e -> e.getType() == type).count();
        if (count >= (long)max) {
            entity.remove();
        }
    }

    public JsonObject fetchVersion(String id) {
        try {
            URL url = new URL("https://api.flubel.com/minecraft/plugins/fetch");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Bearer JobelParallonAquinoNazanin");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            String jsonInput = "{\"id\":\"" + id + "\"}";
            try (OutputStream os = conn.getOutputStream();){
                os.write(jsonInput.getBytes());
                os.flush();
            }
            Scanner scanner = new Scanner(conn.getInputStream());
            StringBuilder response = new StringBuilder();
            while (scanner.hasNext()) {
                response.append(scanner.nextLine());
            }
            scanner.close();
            JsonObject json = (JsonObject)this.gson.fromJson(response.toString(), JsonObject.class);
            if (json.has("success") && json.get("success").getAsBoolean()) {
                return json.getAsJsonObject("data");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

