/*
 * Decompiled with CFR 0.152.
 */
package rvl.stc_lib;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5712;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import rvl.stc_lib.FixerSettings;
import rvl.stc_lib.SimplifyMiningToolItem;

public class SimplifyAxeItem
extends SimplifyMiningToolItem {
    protected static final Map<class_2248, class_2248> STRIPPED_BLOCKS = new ImmutableMap.Builder().put((Object)class_2246.field_10126, (Object)class_2246.field_10250).put((Object)class_2246.field_10431, (Object)class_2246.field_10519).put((Object)class_2246.field_10178, (Object)class_2246.field_10374).put((Object)class_2246.field_10010, (Object)class_2246.field_10244).put((Object)class_2246.field_9999, (Object)class_2246.field_10103).put((Object)class_2246.field_10533, (Object)class_2246.field_10622).put((Object)class_2246.field_42733, (Object)class_2246.field_42730).put((Object)class_2246.field_42729, (Object)class_2246.field_42732).put((Object)class_2246.field_10307, (Object)class_2246.field_10204).put((Object)class_2246.field_10511, (Object)class_2246.field_10366).put((Object)class_2246.field_10303, (Object)class_2246.field_10084).put((Object)class_2246.field_10306, (Object)class_2246.field_10254).put((Object)class_2246.field_10155, (Object)class_2246.field_10558).put((Object)class_2246.field_10037, (Object)class_2246.field_10436).put((Object)class_2246.field_22111, (Object)class_2246.field_22112).put((Object)class_2246.field_22503, (Object)class_2246.field_22504).put((Object)class_2246.field_22118, (Object)class_2246.field_22119).put((Object)class_2246.field_22505, (Object)class_2246.field_22506).put((Object)class_2246.field_37549, (Object)class_2246.field_37550).put((Object)class_2246.field_37545, (Object)class_2246.field_37548).put((Object)class_2246.field_41072, (Object)class_2246.field_41073).build();

    public SimplifyAxeItem(FixerSettings fix, float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(fix, attackDamage, attackSpeed, (class_6862<class_2248>)class_3481.field_33713, settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_1657 playerEntity = context.method_8036();
        if (SimplifyAxeItem.shouldCancelStripAttempt(context)) {
            return class_1269.field_5811;
        }
        Optional<class_2680> optional = this.tryStrip(world, blockPos, playerEntity, world.method_8320(blockPos));
        if (optional.isEmpty()) {
            return class_1269.field_5811;
        }
        class_1799 itemStack = context.method_8041();
        if (playerEntity instanceof class_3222) {
            class_174.field_24478.method_23889((class_3222)playerEntity, blockPos, itemStack);
        }
        world.method_8652(blockPos, optional.get(), 11);
        world.method_43276((class_6880)class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)playerEntity, (class_2680)optional.get()));
        if (playerEntity != null) {
            itemStack.method_7970(1, (class_1309)playerEntity, class_1304.field_6173);
        }
        return class_1269.field_5812;
    }

    private static boolean shouldCancelStripAttempt(class_1838 context) {
        class_1657 playerEntity = context.method_8036();
        return context.method_20287().equals((Object)class_1268.field_5808) && playerEntity.method_6079().method_31574(class_1802.field_8255) && !playerEntity.method_21823();
    }

    private Optional<class_2680> tryStrip(class_1937 world, class_2338 pos, @Nullable class_1657 player, class_2680 state) {
        Optional<class_2680> optional = this.getStrippedState(state);
        if (optional.isPresent()) {
            world.method_8396((class_1297)player, pos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
            return optional;
        }
        Optional optional2 = class_5955.method_34735((class_2680)state);
        if (optional2.isPresent()) {
            world.method_8396((class_1297)player, pos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
            world.method_8444((class_1297)player, 3005, pos, 0);
            return optional2;
        }
        Optional<class_2680> optional3 = Optional.ofNullable((class_2248)((BiMap)class_5953.field_29561.get()).get((Object)state.method_26204())).map(block -> block.method_34725(state));
        if (optional3.isPresent()) {
            world.method_8396((class_1297)player, pos, class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
            world.method_8444((class_1297)player, 3004, pos, 0);
            return optional3;
        }
        return Optional.empty();
    }

    private Optional<class_2680> getStrippedState(class_2680 state) {
        return Optional.ofNullable(STRIPPED_BLOCKS.get(state.method_26204())).map(block -> (class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))));
    }
}

